/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke.reflect;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.server.mvc.invoke.InvocationContext;
import org.springframework.cloud.gateway.server.mvc.invoke.MissingParametersException;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationInvoker;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.cloud.gateway.server.mvc.invoke.ParameterValueMapper;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethod;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectiveOperationInvoker
implements OperationInvoker {
    private final Object target;
    private final OperationMethod operationMethod;
    private final ParameterValueMapper parameterValueMapper;

    public ReflectiveOperationInvoker(OperationMethod operationMethod, ParameterValueMapper parameterValueMapper) {
        this(null, operationMethod, parameterValueMapper);
    }

    public ReflectiveOperationInvoker(Object target, OperationMethod operationMethod, ParameterValueMapper parameterValueMapper) {
        Assert.notNull((Object)operationMethod, (String)"OperationMethod must not be null");
        Assert.notNull((Object)parameterValueMapper, (String)"ParameterValueMapper must not be null");
        ReflectionUtils.makeAccessible((Method)operationMethod.getMethod());
        this.target = target;
        this.operationMethod = operationMethod;
        this.parameterValueMapper = parameterValueMapper;
    }

    @Override
    public <T> T invoke(InvocationContext context) {
        this.validateRequiredParameters(context);
        Method method = this.operationMethod.getMethod();
        Object[] resolvedArguments = this.resolveArguments(context);
        ReflectionUtils.makeAccessible((Method)method);
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)this.target, (Object[])resolvedArguments);
    }

    private void validateRequiredParameters(InvocationContext context) {
        Set<OperationParameter> missing = this.operationMethod.getParameters().stream().filter(parameter -> this.isMissing(context, (OperationParameter)parameter)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            throw new MissingParametersException(missing);
        }
    }

    private boolean isMissing(InvocationContext context, OperationParameter parameter) {
        if (!parameter.isMandatory()) {
            return false;
        }
        if (context.canResolve(parameter.getType())) {
            return false;
        }
        return context.getArguments().get(parameter.getName()) == null;
    }

    private Object[] resolveArguments(InvocationContext context) {
        return this.operationMethod.getParameters().stream().map(parameter -> this.resolveArgument((OperationParameter)parameter, context)).toArray();
    }

    private Object resolveArgument(OperationParameter parameter, InvocationContext context) {
        Object resolvedByType = context.resolveArgument(parameter.getType());
        if (resolvedByType != null) {
            return resolvedByType;
        }
        Object value = context.getArguments().get(parameter.getName());
        return this.parameterValueMapper.mapParameterValue(parameter, value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("target", this.target).append("method", (Object)this.operationMethod).toString();
    }
}

