/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationArgumentResolver;
import org.springframework.util.Assert;

public class InvocationContext {
    private final Map<String, Object> arguments;
    private final List<OperationArgumentResolver> argumentResolvers;

    public InvocationContext(Map<String, Object> arguments, OperationArgumentResolver ... argumentResolvers) {
        Assert.notNull(arguments, (String)"Arguments must not be null");
        this.arguments = arguments;
        this.argumentResolvers = new ArrayList<OperationArgumentResolver>();
        if (argumentResolvers != null) {
            this.argumentResolvers.addAll(Arrays.asList(argumentResolvers));
        }
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public <T> T resolveArgument(Class<T> argumentType) {
        for (OperationArgumentResolver argumentResolver : this.argumentResolvers) {
            T result;
            if (!argumentResolver.canResolve(argumentType) || (result = argumentResolver.resolve(argumentType)) == null) continue;
            return result;
        }
        return null;
    }

    public boolean canResolve(Class<?> type) {
        for (OperationArgumentResolver argumentResolver : this.argumentResolvers) {
            if (!argumentResolver.canResolve(type)) continue;
            return true;
        }
        return false;
    }
}

