/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.DefaultOperationMethod;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethod;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractGatewayDiscoverer {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected volatile MultiValueMap<String, OperationMethod> operations = new LinkedMultiValueMap();

    public <T extends Supplier<Collection<Method>>, R> void doDiscover(Class<T> supplierClass, Class<R> returnType) {
        List<T> suppliers = this.loadSuppliers(supplierClass);
        ArrayList methods = new ArrayList();
        for (Supplier supplier : suppliers) {
            methods.addAll((Collection)supplier.get());
        }
        for (Method method : methods) {
            if (!returnType.isAssignableFrom(method.getReturnType())) continue;
            this.addOperationMethod(method);
        }
    }

    protected void addOperationMethod(Method method) {
        DefaultOperationMethod operationMethod = new DefaultOperationMethod(method);
        String key = method.getName();
        this.operations.add((Object)key, (Object)operationMethod);
        this.log.trace((Object)LogMessage.format((String)"Discovered %s", (Object)operationMethod));
    }

    public abstract void discover();

    protected <T> List<T> loadSuppliers(Class<T> supplierClass) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        List suppliers = SpringFactoriesLoader.loadFactories(supplierClass, (ClassLoader)classLoader);
        return suppliers;
    }

    public MultiValueMap<String, OperationMethod> getOperations() {
        if (this.operations == null || this.operations.isEmpty()) {
            this.discover();
        }
        return this.operations;
    }
}

