/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.mvc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWebRequestProcessingHelper;
import org.springframework.cloud.function.web.util.FunctionWrapper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class FunctionController {
    @PostMapping(path={"/**"}, consumes={"application/x-www-form-urlencoded", "multipart/form-data"})
    @ResponseBody
    public Object form(WebRequest request) {
        MultiValueMap multiFileMap;
        FunctionWrapper wrapper = this.wrapper(request);
        if (((ServletWebRequest)request).getRequest() instanceof StandardMultipartHttpServletRequest && !CollectionUtils.isEmpty((Map)(multiFileMap = ((StandardMultipartHttpServletRequest)((ServletWebRequest)request).getRequest()).getMultiFileMap()))) {
            List files = multiFileMap.values().stream().flatMap(v -> v.stream()).map(file -> MessageBuilder.withPayload((Object)file).copyHeaders((Map)wrapper.getHeaders()).build()).collect(Collectors.toList());
            SimpleFunctionRegistry.FunctionInvocationWrapper function = wrapper.getFunction();
            Publisher result = (Publisher)function.apply((Object)Flux.fromIterable(files));
            ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
            if (result instanceof Flux) {
                result = Flux.from((Publisher)result).map(message -> message instanceof Message ? ((Message)message).getPayload() : message).collectList();
            }
            return Mono.from((Publisher)result).flatMap(body -> Mono.just((Object)builder.body(body)));
        }
        return FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getParams(), false);
    }

    @PostMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<Publisher<?>>> postStream(WebRequest request, @RequestBody(required=false) String body) {
        String argument = StringUtils.hasText((String)body) ? body : "";
        return ((Mono)FunctionWebRequestProcessingHelper.processRequest(this.wrapper(request), argument, true)).map(response -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(response.getHeaders())).body((Object)((Publisher)response.getBody())));
    }

    @GetMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<Publisher<?>>> getStream(WebRequest request) {
        FunctionWrapper wrapper = this.wrapper(request);
        return ((Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), true)).map(response -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(response.getHeaders())).body((Object)((Publisher)response.getBody())));
    }

    @PostMapping(path={"/**"})
    @ResponseBody
    public Object post(WebRequest request, @RequestBody(required=false) String body) {
        String argument = StringUtils.hasText((String)body) ? body : "";
        return FunctionWebRequestProcessingHelper.processRequest(this.wrapper(request), argument, false);
    }

    @GetMapping(path={"/**"})
    @ResponseBody
    public Object get(WebRequest request) {
        FunctionWrapper wrapper = this.wrapper(request);
        return FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), false);
    }

    private FunctionWrapper wrapper(WebRequest request) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)request.getAttribute(WebRequestConstants.HANDLER, 0);
        FunctionWrapper wrapper = new FunctionWrapper(function);
        for (String key : request.getParameterMap().keySet()) {
            wrapper.getParams().addAll((Object)key, Arrays.asList(request.getParameterValues(key)));
        }
        Iterator keys = request.getHeaderNames();
        while (keys.hasNext()) {
            String key;
            key = (String)keys.next();
            wrapper.getHeaders().addAll(key, Arrays.asList(request.getHeaderValues(key)));
        }
        HttpHeaders headers = HttpHeaders.writableHttpHeaders((HttpHeaders)wrapper.getHeaders());
        headers.set("uri", ((ServletWebRequest)request).getRequest().getRequestURI());
        String argument = (String)request.getAttribute(WebRequestConstants.ARGUMENT, 0);
        if (argument != null) {
            wrapper.setArgument(argument);
        }
        return wrapper;
    }
}

