/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import java.util.List;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWebRequestProcessingHelper;
import org.springframework.cloud.function.web.util.FunctionWrapper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class FunctionController {
    @PostMapping(path={"/**"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public Mono<ResponseEntity<?>> form(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        return request.getFormData().doOnSuccess(params -> wrapper.getParams().addAll(params)).then(Mono.defer(() -> (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getParams(), false)));
    }

    @PostMapping(path={"/**"}, consumes={"multipart/form-data"})
    @ResponseBody
    public Mono<ResponseEntity<?>> multipart(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        return request.getMultipartData().doOnSuccess(params -> wrapper.getParams().addAll(this.multi((MultiValueMap<String, Part>)params))).then(Mono.defer(() -> (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getParams(), false)));
    }

    @PostMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> post(ServerWebExchange request, @RequestBody(required=false) String body) {
        return (Mono)FunctionWebRequestProcessingHelper.processRequest(this.wrapper(request), body, false);
    }

    @PostMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<?>> postStream(ServerWebExchange request, @RequestBody(required=false) Flux<String> body) {
        return (Mono)FunctionWebRequestProcessingHelper.processRequest(this.wrapper(request), body, false);
    }

    @GetMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> get(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        return (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), false);
    }

    @GetMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<?>> getStream(ServerWebExchange request) {
        FunctionWrapper wrapper = this.wrapper(request);
        return (Mono)FunctionWebRequestProcessingHelper.processRequest(wrapper, wrapper.getArgument(), true);
    }

    private FunctionWrapper wrapper(ServerWebExchange request) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)request.getAttribute(WebRequestConstants.HANDLER);
        HttpHeaders headers = HttpHeaders.writableHttpHeaders((HttpHeaders)request.getRequest().getHeaders());
        headers.set("uri", request.getRequest().getURI().toString());
        FunctionWrapper wrapper = new FunctionWrapper(function);
        wrapper.setHeaders(headers);
        wrapper.getParams().addAll(request.getRequest().getQueryParams());
        String argument = (String)request.getAttribute(WebRequestConstants.ARGUMENT);
        if (argument != null) {
            wrapper.setArgument(argument);
        }
        return wrapper;
    }

    private MultiValueMap<String, String> multi(MultiValueMap<String, Part> body) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (String key : body.keySet()) {
            for (Part part : (List)body.get((Object)key)) {
                if (!(part instanceof FormFieldPart)) continue;
                FormFieldPart form = (FormFieldPart)part;
                map.add((Object)key, (Object)form.value());
            }
        }
        return map;
    }
}

