/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.cloud.function.web.source.ExporterProperties;
import org.springframework.cloud.function.web.source.HttpSupplier;
import org.springframework.cloud.function.web.source.RequestBuilder;
import org.springframework.cloud.function.web.source.SimpleDestinationResolver;
import org.springframework.cloud.function.web.source.SimpleRequestBuilder;
import org.springframework.cloud.function.web.source.SupplierExporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
@Conditional(value={SourceActiveCondition.class})
@EnableConfigurationProperties(value={ExporterProperties.class})
public class FunctionExporterAutoConfiguration {
    private ExporterProperties props;

    @Autowired
    FunctionExporterAutoConfiguration(ExporterProperties props) {
        this.props = props;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.cloud.function.web.export.sink", name={"url"})
    public SupplierExporter sourceForwarder(RequestBuilder requestBuilder, DestinationResolver destinationResolver, FunctionCatalog catalog, WebClient.Builder builder) {
        return new SupplierExporter(requestBuilder, destinationResolver, catalog, builder.build(), this.props);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.cloud.function.web.export.source", name={"url"})
    public FunctionRegistration<Supplier<Flux<?>>> origin(WebClient.Builder builder) {
        HttpSupplier supplier = new HttpSupplier(builder.build(), this.props);
        FunctionRegistration registration = new FunctionRegistration((Object)supplier, new String[0]);
        Type rawType = ResolvableType.forClassWithGenerics(Supplier.class, (Class[])new Class[]{this.props.getSource().getType()}).getType();
        FunctionType type = FunctionType.of((Type)rawType);
        if (this.props.getSource().isIncludeHeaders()) {
            // empty if block
        }
        registration = registration.type(type);
        return registration;
    }

    @Bean
    public RequestBuilder simpleRequestBuilder(Environment environment) {
        SimpleRequestBuilder builder = new SimpleRequestBuilder(environment);
        if (this.props.getSink().getUrl() != null) {
            builder.setTemplateUrl(this.props.getSink().getUrl());
        }
        builder.setHeaders(this.props.getSink().getHeaders());
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public DestinationResolver simpleDestinationResolver() {
        return new SimpleDestinationResolver();
    }

    static class SourceActiveCondition
    extends AnyNestedCondition {
        SourceActiveCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.cloud.function.web.export", name={"enabled"}, matchIfMissing=true)
        static class Enabled {
            Enabled() {
            }
        }

        @ConditionalOnNotWebApplication
        static class OnNotWebapp {
            OnNotWebapp() {
            }
        }
    }
}

