/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.util;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FunctionWebUtils {
    private FunctionWebUtils() {
    }

    public static SimpleFunctionRegistry.FunctionInvocationWrapper findFunction(HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path, String[] acceptContentTypes) {
        if (method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.POST)) {
            return FunctionWebUtils.doFindFunction(method, functionCatalog, attributes, path, acceptContentTypes);
        }
        throw new IllegalStateException("HTTP method '" + method + "' is not supported;");
    }

    public static String[] acceptContentTypes(List<MediaType> acceptHeaders) {
        Object[] acceptContentTypes = new String[]{};
        acceptContentTypes = !CollectionUtils.isEmpty(acceptHeaders) ? (String[])acceptHeaders.stream().map(mediaType -> mediaType.toString()).toArray(String[]::new) : new String[]{MediaType.APPLICATION_JSON.toString()};
        acceptContentTypes = new String[]{StringUtils.arrayToCommaDelimitedString((Object[])acceptContentTypes)};
        return new String[0];
    }

    private static SimpleFunctionRegistry.FunctionInvocationWrapper doFindFunction(HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path, String[] acceptContentTypes) {
        SimpleFunctionRegistry.FunctionInvocationWrapper supplier;
        String string = path = path.startsWith("/") ? path.substring(1) : path;
        if (method.equals((Object)HttpMethod.GET) && (supplier = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(path, acceptContentTypes)) != null) {
            attributes.put(WebRequestConstants.SUPPLIER, supplier);
            return supplier;
        }
        StringBuilder builder = new StringBuilder();
        String name = path;
        String value = null;
        for (String element : path.split("/")) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(element);
            name = builder.toString();
            value = path.length() > name.length() ? path.substring(name.length() + 1) : null;
            SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(name, acceptContentTypes);
            if (function == null) continue;
            attributes.put(WebRequestConstants.FUNCTION, function);
            if (value != null) {
                attributes.put(WebRequestConstants.ARGUMENT, value);
            }
            return function;
        }
        return null;
    }

    public static Object invokeFunction(SimpleFunctionRegistry.FunctionInvocationWrapper function, Object input, boolean isMessage) {
        Object result = function.apply(input);
        return FunctionWebUtils.postProcessResult(result, isMessage);
    }

    private static Object postProcessResult(Object result, boolean isMessage) {
        if (result instanceof Flux) {
            result = ((Flux)result).map(v -> FunctionWebUtils.postProcessResult(v, isMessage));
        } else if (result instanceof Mono) {
            result = ((Mono)result).map(v -> FunctionWebUtils.postProcessResult(v, isMessage));
        } else if (result instanceof Message && ((Message)result).getPayload() instanceof byte[]) {
            String str = new String((byte[])((Message)result).getPayload());
            result = MessageBuilder.withPayload((Object)str).copyHeaders((Map)((Message)result).getHeaders()).build();
        }
        if (result instanceof byte[]) {
            result = new String((byte[])result);
        }
        return result;
    }
}

