/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.function;

import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.web.RequestProcessor;
import org.springframework.cloud.function.web.util.FunctionWebUtils;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FunctionEndpointFactory {
    private static Log logger = LogFactory.getLog(FunctionEndpointFactory.class);
    private final FunctionCatalog functionCatalog;
    private final String handler;
    private final FunctionInspector inspector;
    private final RequestProcessor processor;

    FunctionEndpointFactory(FunctionCatalog functionCatalog, FunctionInspector inspector, RequestProcessor processor, Environment environment) {
        String handler = environment.resolvePlaceholders("${function.handler}");
        if (handler.startsWith("$")) {
            handler = null;
        }
        this.processor = processor;
        this.inspector = inspector;
        this.functionCatalog = functionCatalog;
        this.handler = handler;
    }

    private Function<Flux<?>, Flux<?>> extract(ServerRequest request) {
        Function function;
        if (this.handler != null) {
            logger.info((Object)("Configured function: " + this.handler));
            Set names = this.functionCatalog.getNames(Function.class);
            Assert.isTrue((boolean)names.contains(this.handler), (String)("Cannot locate function: " + this.handler));
            function = (Function)this.functionCatalog.lookup(Function.class, this.handler);
        } else {
            function = (Function)FunctionWebUtils.findFunction(request.method(), this.functionCatalog, request.attributes(), request.path());
        }
        return function;
    }

    public <T> RouterFunction<?> functionEndpoints() {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.POST((String)"/**"), request -> {
            Function<Flux<?>, Flux<?>> function = this.extract(request);
            Class outputType = this.inspector.getOutputType(function);
            RequestProcessor.FunctionWrapper wrapper = RequestProcessor.wrapper(function, null, null);
            Mono stream = request.bodyToMono(String.class).flatMap(content -> this.processor.post(wrapper, (String)content, false));
            return stream.flatMap(entity -> ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatus)entity.getStatusCode()).headers(headers -> headers.addAll((MultiValueMap)entity.getHeaders()))).body((Publisher)Mono.just((Object)entity.getBody()), outputType));
        });
    }
}

