/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.springframework.http.HttpHeaders;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.ObjectUtils;

public class HeaderUtils {
    public static HttpHeaders fromMessage(MessageHeaders headers, HttpHeaders request) {
        HttpHeaders result = new HttpHeaders();
        for (String name : headers.keySet()) {
            Collection<?> values;
            Object value = headers.get((Object)name);
            if ("id".equals(name = name.toLowerCase())) continue;
            if (request.containsKey((Object)name)) {
                if (!name.startsWith("x-") || name.startsWith("x-forwarded")) continue;
                values = HeaderUtils.multi(value);
                for (Object object : values) {
                    result.set(name, object.toString());
                }
                continue;
            }
            values = HeaderUtils.multi(value);
            for (Object object : values) {
                result.set(name, object.toString());
            }
        }
        return result;
    }

    private static Collection<?> multi(Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection;
        }
        if (ObjectUtils.isArray((Object)value)) {
            Object[] values = ObjectUtils.toObjectArray((Object)value);
            return Arrays.asList(values);
        }
        return Arrays.asList(value);
    }

    public static MessageHeaders fromHttp(HttpHeaders headers) {
        LinkedHashMap map = new LinkedHashMap();
        for (String name : headers.keySet()) {
            Collection<?> values = HeaderUtils.multi(headers.get((Object)name));
            name = name.toLowerCase();
            Collection<?> value = values == null ? null : (values.size() == 1 ? values.iterator().next() : values);
            map.put(name, value);
        }
        return new MessageHeaders(map);
    }
}

