/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux.response;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.messaging.Message;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import reactor.core.publisher.Mono;

class ResponseBodyEmitterSubscriber
implements Subscriber<Object> {
    private final MediaType mediaType;
    private Subscription subscription;
    private final ResponseBodyEmitter responseBodyEmitter;
    private boolean completed;
    private boolean firstElementWritten;
    private boolean single;
    private final boolean json;
    private Message<?> first;
    private final HttpHeaders request;

    public ResponseBodyEmitterSubscriber(HttpHeaders request, MediaType mediaType, Publisher<?> observable, ResponseBodyEmitter responseBodyEmitter, boolean json) {
        this.request = request;
        this.mediaType = mediaType;
        this.responseBodyEmitter = responseBodyEmitter;
        this.json = json;
        this.responseBodyEmitter.onTimeout((Runnable)new Timeout());
        this.responseBodyEmitter.onCompletion((Runnable)new Complete());
        this.single = observable instanceof Mono;
        observable.subscribe((Subscriber)this);
    }

    public void extendResponse(ServerHttpResponse response) {
        this.headers(response);
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(Object value) {
        Object object = value;
        if (object instanceof Message) {
            Message message = (Message)object;
            object = message.getPayload();
            this.first = message;
        }
        try {
            if (this.isJson()) {
                if (!this.firstElementWritten) {
                    if (!this.single) {
                        this.responseBodyEmitter.send((Object)"[");
                        this.firstElementWritten = true;
                    }
                } else {
                    this.responseBodyEmitter.send((Object)",");
                }
                if (!this.single && object.getClass() == String.class && !((String)object).contains("\"")) {
                    object = "\"" + object + "\"";
                }
            }
            if (!this.completed) {
                this.responseBodyEmitter.send(object, this.mediaType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void headers(ServerHttpResponse response) {
        if (this.first != null) {
            Message<?> message = this.first;
            try {
                HttpHeaders headers = HeaderUtils.fromMessage(message.getHeaders(), this.request);
                for (String name : headers.keySet()) {
                    for (String value : headers.get((Object)name)) {
                        response.getHeaders().add(name, value);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onError(Throwable e) {
        if (!this.completed) {
            this.completed = true;
            try {
                if (this.isJson() && !this.single) {
                    if (!this.firstElementWritten) {
                        this.responseBodyEmitter.send((Object)"[]");
                    } else {
                        this.responseBodyEmitter.send((Object)"]");
                    }
                }
                if (e instanceof TimeoutException) {
                    this.responseBodyEmitter.complete();
                } else {
                    this.responseBodyEmitter.completeWithError(e);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    public void onComplete() {
        if (!this.completed) {
            this.completed = true;
            try {
                if (this.isJson() && !this.single) {
                    if (!this.firstElementWritten) {
                        this.responseBodyEmitter.send((Object)"[");
                    }
                    this.responseBodyEmitter.send((Object)"]");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.responseBodyEmitter.complete();
        }
    }

    private boolean isJson() {
        return this.json;
    }

    class Timeout
    implements Runnable {
        Timeout() {
        }

        @Override
        public void run() {
            ResponseBodyEmitterSubscriber.this.onComplete();
            ResponseBodyEmitterSubscriber.this.subscription.cancel();
        }
    }

    class Complete
    implements Runnable {
        Complete() {
        }

        @Override
        public void run() {
            ResponseBodyEmitterSubscriber.this.subscription.cancel();
        }
    }
}

