/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc.ce;

import io.grpc.BindableService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.function.grpc.MessageHandlingHelper;
import org.springframework.cloud.function.grpc.ce.CloudEventHandler;
import org.springframework.cloud.function.grpc.ce.CloudEventMessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.function.grpc.server"}, havingValue="true", matchIfMissing=true)
public class CloudEventGrpcAutoConfiguration {
    @Bean
    public BindableService cloudEventMessageHandler(MessageHandlingHelper helper) {
        return new CloudEventHandler(helper);
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudEventMessageConverter cloudEventMessageConverter() {
        return new CloudEventMessageConverter();
    }
}

