package io.cloudevents.v1;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.4.0)",
    comments = "Source: CloudEventService.proto")
public final class CloudEventServiceGrpc {

  private CloudEventServiceGrpc() {}

  public static final String SERVICE_NAME = "io.cloudevents.v1.CloudEventService";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.cloudevents.v1.proto.CloudEvent,
      io.cloudevents.v1.proto.CloudEvent> METHOD_BI_STREAM =
      io.grpc.MethodDescriptor.<io.cloudevents.v1.proto.CloudEvent, io.cloudevents.v1.proto.CloudEvent>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
          .setFullMethodName(generateFullMethodName(
              "io.cloudevents.v1.CloudEventService", "biStream"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.cloudevents.v1.proto.CloudEvent,
      io.cloudevents.v1.proto.CloudEvent> METHOD_CLIENT_STREAM =
      io.grpc.MethodDescriptor.<io.cloudevents.v1.proto.CloudEvent, io.cloudevents.v1.proto.CloudEvent>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.CLIENT_STREAMING)
          .setFullMethodName(generateFullMethodName(
              "io.cloudevents.v1.CloudEventService", "clientStream"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.cloudevents.v1.proto.CloudEvent,
      io.cloudevents.v1.proto.CloudEvent> METHOD_SERVER_STREAM =
      io.grpc.MethodDescriptor.<io.cloudevents.v1.proto.CloudEvent, io.cloudevents.v1.proto.CloudEvent>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
          .setFullMethodName(generateFullMethodName(
              "io.cloudevents.v1.CloudEventService", "serverStream"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<io.cloudevents.v1.proto.CloudEvent,
      io.cloudevents.v1.proto.CloudEvent> METHOD_REQUEST_REPLY =
      io.grpc.MethodDescriptor.<io.cloudevents.v1.proto.CloudEvent, io.cloudevents.v1.proto.CloudEvent>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "io.cloudevents.v1.CloudEventService", "requestReply"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              io.cloudevents.v1.proto.CloudEvent.getDefaultInstance()))
          .build();

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static CloudEventServiceStub newStub(io.grpc.Channel channel) {
    return new CloudEventServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static CloudEventServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new CloudEventServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static CloudEventServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new CloudEventServiceFutureStub(channel);
  }

  /**
   */
  public static abstract class CloudEventServiceImplBase implements io.grpc.BindableService {

    /**
     */
    public io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> biStream(
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_BI_STREAM, responseObserver);
    }

    /**
     */
    public io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> clientStream(
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      return asyncUnimplementedStreamingCall(METHOD_CLIENT_STREAM, responseObserver);
    }

    /**
     */
    public void serverStream(io.cloudevents.v1.proto.CloudEvent request,
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_SERVER_STREAM, responseObserver);
    }

    /**
     */
    public void requestReply(io.cloudevents.v1.proto.CloudEvent request,
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_REQUEST_REPLY, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_BI_STREAM,
            asyncBidiStreamingCall(
              new MethodHandlers<
                io.cloudevents.v1.proto.CloudEvent,
                io.cloudevents.v1.proto.CloudEvent>(
                  this, METHODID_BI_STREAM)))
          .addMethod(
            METHOD_CLIENT_STREAM,
            asyncClientStreamingCall(
              new MethodHandlers<
                io.cloudevents.v1.proto.CloudEvent,
                io.cloudevents.v1.proto.CloudEvent>(
                  this, METHODID_CLIENT_STREAM)))
          .addMethod(
            METHOD_SERVER_STREAM,
            asyncServerStreamingCall(
              new MethodHandlers<
                io.cloudevents.v1.proto.CloudEvent,
                io.cloudevents.v1.proto.CloudEvent>(
                  this, METHODID_SERVER_STREAM)))
          .addMethod(
            METHOD_REQUEST_REPLY,
            asyncUnaryCall(
              new MethodHandlers<
                io.cloudevents.v1.proto.CloudEvent,
                io.cloudevents.v1.proto.CloudEvent>(
                  this, METHODID_REQUEST_REPLY)))
          .build();
    }
  }

  /**
   */
  public static final class CloudEventServiceStub extends io.grpc.stub.AbstractStub<CloudEventServiceStub> {
    private CloudEventServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CloudEventServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CloudEventServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CloudEventServiceStub(channel, callOptions);
    }

    /**
     */
    public io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> biStream(
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(METHOD_BI_STREAM, getCallOptions()), responseObserver);
    }

    /**
     */
    public io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> clientStream(
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      return asyncClientStreamingCall(
          getChannel().newCall(METHOD_CLIENT_STREAM, getCallOptions()), responseObserver);
    }

    /**
     */
    public void serverStream(io.cloudevents.v1.proto.CloudEvent request,
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(METHOD_SERVER_STREAM, getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void requestReply(io.cloudevents.v1.proto.CloudEvent request,
        io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_REQUEST_REPLY, getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class CloudEventServiceBlockingStub extends io.grpc.stub.AbstractStub<CloudEventServiceBlockingStub> {
    private CloudEventServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CloudEventServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CloudEventServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CloudEventServiceBlockingStub(channel, callOptions);
    }

    /**
     */
    public java.util.Iterator<io.cloudevents.v1.proto.CloudEvent> serverStream(
        io.cloudevents.v1.proto.CloudEvent request) {
      return blockingServerStreamingCall(
          getChannel(), METHOD_SERVER_STREAM, getCallOptions(), request);
    }

    /**
     */
    public io.cloudevents.v1.proto.CloudEvent requestReply(io.cloudevents.v1.proto.CloudEvent request) {
      return blockingUnaryCall(
          getChannel(), METHOD_REQUEST_REPLY, getCallOptions(), request);
    }
  }

  /**
   */
  public static final class CloudEventServiceFutureStub extends io.grpc.stub.AbstractStub<CloudEventServiceFutureStub> {
    private CloudEventServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private CloudEventServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected CloudEventServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new CloudEventServiceFutureStub(channel, callOptions);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.cloudevents.v1.proto.CloudEvent> requestReply(
        io.cloudevents.v1.proto.CloudEvent request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_REQUEST_REPLY, getCallOptions()), request);
    }
  }

  private static final int METHODID_SERVER_STREAM = 0;
  private static final int METHODID_REQUEST_REPLY = 1;
  private static final int METHODID_BI_STREAM = 2;
  private static final int METHODID_CLIENT_STREAM = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final CloudEventServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(CloudEventServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_SERVER_STREAM:
          serviceImpl.serverStream((io.cloudevents.v1.proto.CloudEvent) request,
              (io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent>) responseObserver);
          break;
        case METHODID_REQUEST_REPLY:
          serviceImpl.requestReply((io.cloudevents.v1.proto.CloudEvent) request,
              (io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_BI_STREAM:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.biStream(
              (io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent>) responseObserver);
        case METHODID_CLIENT_STREAM:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.clientStream(
              (io.grpc.stub.StreamObserver<io.cloudevents.v1.proto.CloudEvent>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static final class CloudEventServiceDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier {
    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.cloudevents.v1.CloudEventServiceOuterClass.getDescriptor();
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (CloudEventServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new CloudEventServiceDescriptorSupplier())
              .addMethod(METHOD_BI_STREAM)
              .addMethod(METHOD_CLIENT_STREAM)
              .addMethod(METHOD_SERVER_STREAM)
              .addMethod(METHOD_REQUEST_REPLY)
              .build();
        }
      }
    }
    return result;
  }
}
