/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.gson.Gson;
import io.cloudevents.spring.messaging.CloudEventMessageConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.cloudevent.CloudEventsFunctionInvocationHelper;
import org.springframework.cloud.function.context.DefaultMessageRoutingHandler;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.MessageRoutingCallback;
import org.springframework.cloud.function.context.catalog.BeanFactoryAwareFunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.JsonMessageConverter;
import org.springframework.cloud.function.context.config.MessageConverterHelper;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.context.config.SmartCompositeMessageConverter;
import org.springframework.cloud.function.core.FunctionInvocationHelper;
import org.springframework.cloud.function.json.GsonMapper;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.InvalidMimeTypeException;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FunctionProperties.class})
@AutoConfigureAfter(name={"org.springframework.cloud.function.deployer.FunctionDeployerConfiguration"})
public class ContextFunctionCatalogAutoConfiguration {
    private static Log logger = LogFactory.getLog(ContextFunctionCatalogAutoConfiguration.class);
    public static final String JSON_MAPPER_PROPERTY = "spring.cloud.function.preferred-json-mapper";

    @Bean
    public FunctionRegistry functionCatalog(List<MessageConverter> messageConverters, JsonMapper jsonMapper, ConfigurableApplicationContext context, @Nullable FunctionInvocationHelper<Message<?>> functionInvocationHelper) {
        ConfigurableConversionService conversionService = (ConfigurableConversionService)context.getBeanFactory().getConversionService();
        if (conversionService == null) {
            conversionService = new DefaultConversionService();
        }
        Map converters = context.getBeansOfType(GenericConverter.class);
        for (GenericConverter converter : converters.values()) {
            conversionService.addConverter(converter);
        }
        SmartCompositeMessageConverter messageConverter = null;
        List<Object> mcList = new ArrayList();
        if (!CollectionUtils.isEmpty(messageConverters)) {
            for (MessageConverter mc : messageConverters) {
                if (mc instanceof CompositeMessageConverter) {
                    List conv = ((CompositeMessageConverter)mc).getConverters().stream().toList();
                    mcList.addAll(conv);
                    continue;
                }
                mcList.add(mc);
            }
        }
        mcList = mcList.stream().filter(this::isConverterEligible).collect(Collectors.toList());
        mcList.add((Object)new JsonMessageConverter(jsonMapper));
        mcList.add(new ByteArrayMessageConverter());
        StringMessageConverter stringConverter = new StringMessageConverter();
        stringConverter.setSerializedPayloadClass(String.class);
        stringConverter.setContentTypeResolver(new ContentTypeResolver(){

            public MimeType resolve(MessageHeaders headers) throws InvalidMimeTypeException {
                if (headers.containsKey((Object)"contentType")) {
                    if (headers.get((Object)"contentType").toString().startsWith("text")) {
                        return MimeType.valueOf((String)"text/plain");
                    }
                    return MimeType.valueOf((String)headers.get((Object)"contentType").toString());
                }
                return null;
            }
        });
        mcList.add(stringConverter);
        messageConverter = new SmartCompositeMessageConverter(mcList, () -> context.getBeansOfType(MessageConverterHelper.class).values());
        if (functionInvocationHelper instanceof CloudEventsFunctionInvocationHelper) {
            ((CloudEventsFunctionInvocationHelper)functionInvocationHelper).setMessageConverter(messageConverter);
        }
        FunctionProperties functionProperties = (FunctionProperties)context.getBean(FunctionProperties.class);
        return new BeanFactoryAwareFunctionRegistry((ConversionService)conversionService, messageConverter, jsonMapper, functionProperties, functionInvocationHelper);
    }

    @Bean(value={"functionRouter"})
    public RoutingFunction functionRouter(FunctionCatalog functionCatalog, FunctionProperties functionProperties, BeanFactory beanFactory, @Nullable MessageRoutingCallback routingCallback, @Nullable DefaultMessageRoutingHandler defaultMessageRoutingHandler) {
        if (defaultMessageRoutingHandler != null) {
            FunctionRegistration<DefaultMessageRoutingHandler> functionRegistration = new FunctionRegistration<DefaultMessageRoutingHandler>(defaultMessageRoutingHandler, "defaultMessageRoutingHandler");
            functionRegistration.type(FunctionTypeUtils.consumerType(ResolvableType.forClassWithGenerics(Message.class, (Class[])new Class[]{Object.class}).getType()));
            ((FunctionRegistry)functionCatalog).register(functionRegistration);
        }
        return new RoutingFunction(functionCatalog, functionProperties, (BeanResolver)new BeanFactoryResolver(beanFactory), routingCallback);
    }

    private boolean isConverterEligible(Object messageConverter) {
        String messageConverterName = messageConverter.getClass().getName();
        if (messageConverterName.startsWith("org.springframework.cloud.")) {
            return true;
        }
        return !messageConverterName.startsWith("org.springframework.");
    }

    @Configuration(proxyBeanMethods=false)
    public static class JsonMapperConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={JsonMapper.class})
        public JsonMapper jsonMapper(ApplicationContext context) {
            String preferredMapper = context.getEnvironment().getProperty(ContextFunctionCatalogAutoConfiguration.JSON_MAPPER_PROPERTY);
            if (StringUtils.hasText((String)preferredMapper)) {
                if ("gson".equals(preferredMapper) && ClassUtils.isPresent((String)"com.google.gson.Gson", null)) {
                    return this.gson(context);
                }
                if ("jackson".equals(preferredMapper) && ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null)) {
                    return this.jackson(context);
                }
            } else {
                if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null)) {
                    return this.jackson(context);
                }
                if (ClassUtils.isPresent((String)"com.google.gson.Gson", null)) {
                    return this.gson(context);
                }
            }
            throw new IllegalStateException("Failed to configure JsonMapper. Neither jackson nor gson are present on the claspath");
        }

        private JsonMapper gson(ApplicationContext context) {
            Gson gson;
            try {
                gson = (Gson)context.getBean(Gson.class);
            }
            catch (Exception e) {
                gson = new Gson();
            }
            return new GsonMapper(gson);
        }

        private JsonMapper jackson(ApplicationContext context) {
            ObjectMapper mapper;
            try {
                mapper = ((ObjectMapper)context.getBean(ObjectMapper.class)).copy();
            }
            catch (Exception e) {
                mapper = new ObjectMapper();
                mapper.registerModule((Module)new JavaTimeModule());
            }
            mapper.registerModule((Module)new JodaModule());
            if (KotlinDetector.isKotlinPresent()) {
                try {
                    if (!mapper.getRegisteredModuleIds().contains("com.fasterxml.jackson.module.kotlin.KotlinModule")) {
                        Class kotlinModuleClass = ClassUtils.forName((String)"com.fasterxml.jackson.module.kotlin.KotlinModule", (ClassLoader)ClassUtils.getDefaultClassLoader());
                        Module kotlinModule = (Module)BeanUtils.instantiateClass((Class)kotlinModuleClass);
                        mapper.registerModule(kotlinModule);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            mapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ObjectMapper configuration: " + JsonMapperConfiguration.getConfigDetails(mapper)));
            }
            return new JacksonMapper(mapper);
        }

        private static String getConfigDetails(ObjectMapper mapper) {
            StringBuilder sb = new StringBuilder();
            sb.append("Modules:\n");
            if (mapper.getRegisteredModuleIds().isEmpty()) {
                sb.append("\t").append("-none-").append("\n");
            }
            for (Object m : mapper.getRegisteredModuleIds()) {
                sb.append("  ").append(m).append("\n");
            }
            sb.append("\nSerialization Features:\n");
            for (SerializationFeature serializationFeature : SerializationFeature.values()) {
                sb.append("\t").append(serializationFeature).append(" -> ").append(mapper.getSerializationConfig().hasSerializationFeatures(serializationFeature.getMask()));
                if (serializationFeature.enabledByDefault()) {
                    sb.append(" (enabled by default)");
                }
                sb.append("\n");
            }
            sb.append("\nDeserialization Features:\n");
            for (SerializationFeature serializationFeature : DeserializationFeature.values()) {
                sb.append("\t").append(serializationFeature).append(" -> ").append(mapper.getDeserializationConfig().hasDeserializationFeatures(serializationFeature.getMask()));
                if (serializationFeature.enabledByDefault()) {
                    sb.append(" (enabled by default)");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    @ComponentScan(basePackages={"${spring.cloud.function.scan.packages:functions}"}, includeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={Supplier.class, Function.class, Consumer.class})}, excludeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, classes={Configuration.class, Component.class})})
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.cloud.function.scan", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class PlainFunctionScanConfiguration {
        protected PlainFunctionScanConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"io.cloudevents.spring.messaging.CloudEventMessageConverter"})
    static class CloudEventsMessageConverterConfiguration {
        CloudEventsMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public CloudEventMessageConverter cloudEventMessageConverter() {
            return new CloudEventMessageConverter();
        }
    }
}

