/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.BeanFactoryAwareFunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.config.ApplicationJsonMessageMarshallingConverter;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.json.GsonMapper;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={FunctionCatalog.class})
@EnableConfigurationProperties(value={FunctionProperties.class})
public class ContextFunctionCatalogAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";

    @Bean
    public FunctionRegistry functionCatalog(List<MessageConverter> messageConverters, @Nullable ObjectMapper objectMapper) {
        DefaultConversionService conversionService = new DefaultConversionService();
        CompositeMessageConverter messageConverter = null;
        messageConverters = messageConverters.stream().filter(c -> this.isConverterEligible(c)).collect(Collectors.toList());
        ArrayList<Object> mcList = new ArrayList<Object>();
        boolean addDefaultConverters = true;
        if (!CollectionUtils.isEmpty(messageConverters)) {
            for (MessageConverter messageConverter2 : messageConverters) {
                if (messageConverter2 instanceof CompositeMessageConverter) {
                    mcList.addAll(((CompositeMessageConverter)messageConverter2).getConverters());
                    addDefaultConverters = false;
                    continue;
                }
                mcList.add(messageConverter2);
            }
        }
        if (addDefaultConverters) {
            if (objectMapper == null) {
                objectMapper = new ObjectMapper();
            }
            mcList.add((Object)new ApplicationJsonMessageMarshallingConverter(objectMapper));
            mcList.add(new ByteArrayMessageConverter());
            mcList.add(new StringMessageConverter());
        }
        messageConverter = new CompositeMessageConverter(mcList);
        return new BeanFactoryAwareFunctionRegistry((ConversionService)conversionService, messageConverter);
    }

    @Bean(value={"functionRouter"})
    RoutingFunction functionRouter(FunctionCatalog functionCatalog, FunctionInspector functionInspector, FunctionProperties functionProperties) {
        return new RoutingFunction(functionCatalog, functionInspector, functionProperties);
    }

    private boolean isConverterEligible(Object messageConverter) {
        String messageConverterName = messageConverter.getClass().getName();
        if (messageConverterName.startsWith("org.springframework.cloud.")) {
            return true;
        }
        return !messageConverterName.startsWith("org.springframework.");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    protected static class JacksonConfiguration {
        protected JacksonConfiguration() {
        }

        @Bean
        public JacksonMapper jsonMapper(ObjectMapper mapper) {
            return new JacksonMapper(mapper);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Gson.class})
    @ConditionalOnBean(value={Gson.class})
    @Conditional(value={PreferGsonOrMissingJacksonCondition.class})
    protected static class GsonConfiguration {
        protected GsonConfiguration() {
        }

        @Bean
        public GsonMapper jsonMapper(Gson gson) {
            return new GsonMapper(gson);
        }
    }

    private static class PreferGsonOrMissingJacksonCondition
    extends AnyNestedCondition {
        PreferGsonOrMissingJacksonCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={ObjectMapper.class})
        static class JacksonMissing {
            JacksonMissing() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="gson", matchIfMissing=false)
        static class GsonPreferred {
            GsonPreferred() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ComponentScan(basePackages={"${spring.cloud.function.scan.packages:functions}"}, includeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={Supplier.class, Function.class, Consumer.class})})
    @ConditionalOnProperty(prefix="spring.cloud.function.scan", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class PlainFunctionScanConfiguration {
        protected PlainFunctionScanConfiguration() {
        }
    }
}

