/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;

public class RoutingFunction
implements Function<Publisher<Message<?>>, Publisher<?>> {
    public static final String FUNCTION_NAME = "router";
    private final FunctionCatalog functionCatalog;
    private final FunctionInspector functionInspector;
    private final MessageConverter messageConverter;

    RoutingFunction(FunctionCatalog functionCatalog, FunctionInspector functionInspector, MessageConverter messageConverter) {
        this.functionCatalog = functionCatalog;
        this.functionInspector = functionInspector;
        this.messageConverter = messageConverter;
    }

    @Override
    public Publisher<?> apply(Publisher<Message<?>> input) {
        return Flux.from(input).switchOnFirst((signal, flux) -> {
            Assert.isTrue((signal.hasValue() && signal.getType() == SignalType.ON_NEXT ? 1 : 0) != 0, (String)("Signal has no value or wrong type " + signal));
            Function function = this.getRouteToFunction((Message)signal.get());
            return flux.map(message -> {
                Object inputValue = this.convertInput((Message<?>)message, function);
                return inputValue;
            }).log().doOnError(error -> {
                throw new IllegalStateException("Failed to convert Message. Possible reason; No suitable converter was found for payload with 'contentType' " + ((Message)signal.get()).getHeaders().get((Object)"contentType"), (Throwable)error);
            }).transform(function);
        });
    }

    private Function getRouteToFunction(Message<?> message) {
        String routeToFunctionName = (String)message.getHeaders().get((Object)"function.name");
        Assert.hasText((String)routeToFunctionName, (String)"A 'function.name' was not provided as message header.");
        Function function = (Function)this.functionCatalog.lookup(routeToFunctionName);
        Assert.notNull((Object)function, (String)("Failed to locate function specified with 'function.name':" + message.getHeaders().get((Object)"function.name")));
        return function;
    }

    private Object convertInput(Message<?> message, Object function) {
        Class<?> inputType = this.functionInspector.getInputType(function);
        Object inputValue = message.getPayload();
        if (!inputValue.getClass().isAssignableFrom(inputType)) {
            inputValue = this.messageConverter.fromMessage(message, this.functionInspector.getInputType(function));
        }
        if (this.functionInspector.isMessage(function)) {
            inputValue = MessageBuilder.createMessage((Object)inputValue, (MessageHeaders)message.getHeaders());
        }
        Assert.notNull((Object)inputValue, (String)("Failed to determine input value of type " + inputType + " from Message '" + message + "'. No suitable Message Converter found."));
        return inputValue;
    }
}

