/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.core.FluxConsumer;
import org.springframework.cloud.function.core.FluxFunction;
import org.springframework.cloud.function.core.FluxSupplier;
import org.springframework.cloud.function.core.FluxToMonoFunction;
import org.springframework.cloud.function.core.FluxedConsumer;
import org.springframework.cloud.function.core.FluxedFunction;
import org.springframework.cloud.function.core.MonoSupplier;
import org.springframework.cloud.function.core.MonoToFluxFunction;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FunctionRegistration<T>
implements BeanNameAware {
    private final Set<String> names = new LinkedHashSet<String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private T target;
    private FunctionType type;

    public FunctionRegistration(T target, String ... names) {
        Assert.notNull(target, (String)"'target' must not be null");
        this.target = target;
        this.names(names);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public void setNames(Set<String> names) {
        this.names.clear();
        this.names.addAll(names);
    }

    public FunctionType getType() {
        return this.type;
    }

    public T getTarget() {
        return this.target;
    }

    public FunctionRegistration<T> properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public FunctionRegistration<T> type(Type type) {
        this.type = FunctionType.of(type);
        return this;
    }

    public FunctionRegistration<T> type(FunctionType type) {
        this.type = type;
        return this;
    }

    public FunctionRegistration<T> target(T target) {
        this.target = target;
        return this;
    }

    public FunctionRegistration<T> name(String name) {
        return this.names(name);
    }

    public FunctionRegistration<T> names(Collection<String> names) {
        this.names.addAll(names);
        return this;
    }

    public FunctionRegistration<T> names(String ... names) {
        return this.names(Arrays.asList(names));
    }

    public <S> FunctionRegistration<S> wrap() {
        FunctionRegistration<T> result;
        this.isFunctionSignatureSupported();
        if (this.type == null) {
            result = this;
        } else if (this.target instanceof RoutingFunction) {
            T target = this.target;
            result = new FunctionRegistration<T>(target, new String[0]);
            result.type(this.type.getType());
            result = result.target(target).names(this.names).type(result.type.wrap(Flux.class)).properties(this.properties);
        } else {
            Object target = this.target;
            result = new FunctionRegistration<T>(target, new String[0]);
            result.type(this.type.getType());
            if (!this.type.isWrapper()) {
                target = target instanceof Supplier ? new FluxSupplier((Supplier)target) : (target instanceof Function ? new FluxFunction((Function)target) : new FluxConsumer((Consumer)target));
            } else if (Mono.class.isAssignableFrom(this.type.getOutputWrapper())) {
                target = target instanceof Supplier ? new MonoSupplier((Supplier)target) : new FluxToMonoFunction((Function)target);
            } else if (Mono.class.isAssignableFrom(this.type.getInputWrapper())) {
                target = new MonoToFluxFunction((Function)target);
            } else if (target instanceof Consumer) {
                target = new FluxedConsumer((Consumer)target);
            } else if (target instanceof Function) {
                target = new FluxedFunction((Function)target);
            }
            result = result.target(target).names(this.names).type(result.type.wrap(Flux.class)).properties(this.properties);
        }
        return result;
    }

    public void setBeanName(String name) {
        if (CollectionUtils.isEmpty(this.names)) {
            this.name(name);
        }
    }

    private void isFunctionSignatureSupported() {
        if (this.type != null) {
            Assert.isTrue((!Mono.class.isAssignableFrom(this.type.getOutputWrapper()) || !Mono.class.isAssignableFrom(this.type.getInputWrapper()) ? 1 : 0) != 0, (String)"Function<Mono, Mono> is not supported.");
        }
    }
}

