/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.function.core.FunctionFactoryMetadata;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.core.type.classreading.MethodMetadataReadingVisitor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class FunctionContextUtils {
    public static Type findType(String name, ConfigurableListableBeanFactory registry) {
        AbstractBeanDefinition definition = (AbstractBeanDefinition)registry.getBeanDefinition(name);
        Object source = definition.getSource();
        Type param = null;
        if (source instanceof StandardMethodMetadata) {
            param = ((StandardMethodMetadata)source).getIntrospectedMethod().getGenericReturnType();
        } else if (source instanceof MethodMetadataReadingVisitor) {
            MethodMetadataReadingVisitor visitor = (MethodMetadataReadingVisitor)source;
            param = FunctionContextUtils.findBeanType(definition, visitor);
        } else if (source instanceof Resource) {
            param = registry.getType(name);
        } else {
            ResolvableType type = (ResolvableType)FunctionContextUtils.getField(definition, "targetType");
            if (type != null) {
                param = type.getType();
            } else {
                Class beanClass = definition.getBeanClass();
                if (beanClass != null && !FunctionFactoryMetadata.class.isAssignableFrom(beanClass)) {
                    param = beanClass;
                } else {
                    FunctionFactoryMetadata factory = (FunctionFactoryMetadata)registry.getBean(name);
                    param = factory.getFactoryMethod().getGenericReturnType();
                }
            }
        }
        return param;
    }

    private static Type findBeanType(AbstractBeanDefinition definition, MethodMetadataReadingVisitor visitor) {
        Class factory = ClassUtils.resolveClassName((String)visitor.getDeclaringClassName(), null);
        Class[] params = FunctionContextUtils.getParamTypes(factory, definition);
        Method method = ReflectionUtils.findMethod((Class)factory, (String)visitor.getMethodName(), (Class[])params);
        Type type = method.getGenericReturnType();
        return type;
    }

    private static Class<?>[] getParamTypes(Class<?> factory, AbstractBeanDefinition definition) {
        if (definition instanceof RootBeanDefinition) {
            RootBeanDefinition root = (RootBeanDefinition)definition;
            for (Method method : FunctionContextUtils.getCandidateMethods(factory, root)) {
                if (!root.isFactoryMethod(method)) continue;
                return method.getParameterTypes();
            }
        }
        ArrayList<Class> params = new ArrayList<Class>();
        for (ConstructorArgumentValues.ValueHolder holder : definition.getConstructorArgumentValues().getIndexedArgumentValues().values()) {
            params.add(ClassUtils.resolveClassName((String)holder.getType(), null));
        }
        return params.toArray(new Class[0]);
    }

    private static Method[] getCandidateMethods(final Class<?> factoryClass, final RootBeanDefinition mbd) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods((Class)factoryClass) : factoryClass.getMethods();
                }
            });
        }
        return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }

    private static Object getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }
}

