/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionRegistrationEvent;
import org.springframework.cloud.function.context.catalog.FunctionUnregistrationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public class InMemoryFunctionCatalog
implements FunctionRegistry,
ApplicationEventPublisherAware {
    private final Map<Class<?>, Map<String, Object>> functions;
    @Autowired(required=false)
    private ApplicationEventPublisher publisher;

    public InMemoryFunctionCatalog() {
        this(Collections.emptySet());
    }

    public InMemoryFunctionCatalog(Set<FunctionRegistration<?>> registrations) {
        Assert.notNull(registrations, (String)"'registrations' must not be null");
        this.functions = new HashMap();
        registrations.stream().forEach(reg -> this.register((FunctionRegistration)reg));
    }

    @Override
    public <T> void register(FunctionRegistration<T> registration) {
        FunctionRegistrationEvent event;
        Class type;
        if (registration.getTarget() instanceof Function) {
            type = Function.class;
            event = new FunctionRegistrationEvent(this, Function.class, registration.getNames());
        } else if (registration.getTarget() instanceof Supplier) {
            type = Supplier.class;
            event = new FunctionRegistrationEvent(this, Supplier.class, registration.getNames());
        } else if (registration.getTarget() instanceof Consumer) {
            type = Consumer.class;
            event = new FunctionRegistrationEvent(this, Consumer.class, registration.getNames());
        } else {
            type = Object.class;
            event = new FunctionRegistrationEvent(this, Object.class, registration.getNames());
        }
        Map map = this.functions.computeIfAbsent(type, key -> new HashMap());
        for (String name : registration.getNames()) {
            map.put(name, registration.getTarget());
        }
        this.publisher.publishEvent((ApplicationEvent)event);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @PostConstruct
    public void init() {
        if (this.publisher != null && !this.functions.isEmpty()) {
            for (Class<?> type : this.functions.keySet()) {
                this.publisher.publishEvent((ApplicationEvent)new FunctionRegistrationEvent(this, type, this.functions.get(type).keySet()));
            }
        }
    }

    @PreDestroy
    public void close() {
        if (this.publisher != null && !this.functions.isEmpty()) {
            for (Class<?> type : this.functions.keySet()) {
                this.publisher.publishEvent((ApplicationEvent)new FunctionUnregistrationEvent(this, type, this.functions.get(type).keySet()));
            }
        }
    }

    @Override
    public <T> T lookup(Class<?> type, String name) {
        Map<String, Object> map = null;
        for (Class<?> key : this.functions.keySet()) {
            if (key == Object.class || !key.isAssignableFrom(type)) continue;
            map = this.functions.get(key);
            break;
        }
        if (map == null) {
            map = this.functions.get(Object.class);
        }
        Object result = map.get(name);
        return (T)result;
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        Map<String, Object> map = null;
        for (Class<?> key : this.functions.keySet()) {
            if (key == Object.class || !key.isAssignableFrom(type)) continue;
            map = this.functions.get(key);
            break;
        }
        if (map == null) {
            map = this.functions.get(Object.class);
        }
        return map == null ? Collections.emptySet() : map.keySet();
    }
}

