/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.util.Assert;

public class FunctionRegistration<T> {
    private T target;
    private final Set<String> names = new LinkedHashSet<String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private FunctionType type;

    public FunctionRegistration(T target) {
        Assert.notNull(target, (String)"'target' must not be null");
        this.target = target;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public FunctionType getType() {
        return this.type;
    }

    public void setNames(Set<String> names) {
        this.names.clear();
        this.names.addAll(names);
    }

    public T getTarget() {
        return this.target;
    }

    public FunctionRegistration<T> properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public FunctionRegistration<T> type(Type type) {
        this.type = FunctionType.of(type);
        return this;
    }

    public FunctionRegistration<T> target(T target) {
        this.target = target;
        return this;
    }

    public FunctionRegistration<T> name(String name) {
        return this.names(name);
    }

    public FunctionRegistration<T> names(Collection<String> names) {
        this.names.addAll(names);
        return this;
    }

    public FunctionRegistration<T> names(String ... names) {
        return this.names(Arrays.asList(names));
    }
}

