/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.app;

import org.springframework.cloud.function.compiler.app.CompiledFunctionRegistry;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CompilerController {
    private final CompiledFunctionRegistry registry = new CompiledFunctionRegistry();

    @PostMapping(path={"/supplier/{name}"})
    public void registerSupplier(@PathVariable String name, @RequestBody String lambda, @RequestParam(defaultValue="Flux<String>") String type) {
        this.registry.registerSupplier(name, lambda, type);
    }

    @PostMapping(path={"/function/{name}"})
    public void registerFunction(@PathVariable String name, @RequestBody String lambda, @RequestParam(defaultValue="Flux<String>") String inputType, @RequestParam(defaultValue="Flux<String>") String outputType) {
        this.registry.registerFunction(name, lambda, inputType, outputType);
    }

    @PostMapping(path={"/consumer/{name}"})
    public void registerConsumer(@PathVariable String name, @RequestBody String lambda, @RequestParam(defaultValue="Flux<String>") String type) {
        this.registry.registerConsumer(name, lambda, type);
    }
}

