/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

public class DirEnumeration
implements Enumeration<File> {
    private File basedir;
    private List<File> filesToReturn;
    private List<File> directoriesToExplore;

    public DirEnumeration(File basedir) {
        this.basedir = basedir;
    }

    private void computeValue() {
        if (this.filesToReturn == null) {
            this.filesToReturn = new ArrayList<File>();
            this.directoriesToExplore = new ArrayList<File>();
            this.visitDirectory(this.basedir);
        }
        if (this.filesToReturn.size() == 0) {
            while (this.filesToReturn.size() == 0 && this.directoriesToExplore.size() != 0) {
                File nextDir = this.directoriesToExplore.get(0);
                this.directoriesToExplore.remove(0);
                this.visitDirectory(nextDir);
            }
        }
    }

    @Override
    public boolean hasMoreElements() {
        this.computeValue();
        return this.filesToReturn.size() != 0;
    }

    @Override
    public File nextElement() {
        this.computeValue();
        if (this.filesToReturn.size() == 0) {
            throw new NoSuchElementException();
        }
        File toReturn = this.filesToReturn.get(0);
        this.filesToReturn.remove(0);
        return toReturn;
    }

    private void visitDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.directoriesToExplore.add(file);
                    continue;
                }
                this.filesToReturn.add(file);
            }
        }
    }

    public File getDirectory() {
        return this.basedir;
    }

    public String getName(File file) {
        String basedirPath = this.basedir.getPath();
        String filePath = file.getPath();
        if (!filePath.startsWith(basedirPath)) {
            throw new IllegalStateException("The file '" + filePath + "' is not nested below the base directory '" + basedirPath + "'");
        }
        return filePath.substring(basedirPath.length() + 1);
    }
}

