/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import javax.tools.JavaFileObject;
import org.springframework.cloud.function.compiler.java.MemoryBasedJavaFileManager;

public abstract class CloseableFilterableJavaFileObjectIterable
implements Iterable<JavaFileObject> {
    private static final boolean BOOT_PACKAGING_AWARE = true;
    private static final String BOOT_PACKAGING_PREFIX_FOR_CLASSES = "BOOT-INF/classes/";
    protected String packageNameFilter;
    protected boolean includeSubpackages;
    protected MemoryBasedJavaFileManager.CompilationInfoCache compilationInfoCache;

    public CloseableFilterableJavaFileObjectIterable(MemoryBasedJavaFileManager.CompilationInfoCache compilationInfoCache, String packageNameFilter, boolean includeSubpackages) {
        if (packageNameFilter != null && packageNameFilter.contains(File.separator)) {
            throw new IllegalArgumentException("Package name filters should use dots to separate components: " + packageNameFilter);
        }
        this.compilationInfoCache = compilationInfoCache;
        this.packageNameFilter = packageNameFilter == null ? null : packageNameFilter.replace('.', '/') + '/';
        this.includeSubpackages = includeSubpackages;
    }

    protected boolean accept(String name) {
        boolean accept;
        if (!name.endsWith(".class")) {
            return false;
        }
        if (this.packageNameFilter == null) {
            return true;
        }
        name = name.replace('\\', '/');
        if (this.packageNameFilter.length() == 1 && this.packageNameFilter.equals("/")) {
            boolean accept2 = name.indexOf(47) == -1 ? true : name.startsWith(BOOT_PACKAGING_PREFIX_FOR_CLASSES) && name.indexOf(47, BOOT_PACKAGING_PREFIX_FOR_CLASSES.length()) == -1;
            return accept2;
        }
        if (this.includeSubpackages) {
            accept = name.startsWith(this.packageNameFilter);
            if (!accept) {
                accept = name.startsWith(BOOT_PACKAGING_PREFIX_FOR_CLASSES) && name.indexOf(this.packageNameFilter) == BOOT_PACKAGING_PREFIX_FOR_CLASSES.length();
            }
        } else {
            boolean bl = accept = name.startsWith(this.packageNameFilter) && name.indexOf("/", this.packageNameFilter.length()) == -1;
            if (!accept) {
                accept = name.startsWith(BOOT_PACKAGING_PREFIX_FOR_CLASSES) && name.indexOf(this.packageNameFilter) == BOOT_PACKAGING_PREFIX_FOR_CLASSES.length() && name.indexOf("/", BOOT_PACKAGING_PREFIX_FOR_CLASSES.length() + this.packageNameFilter.length()) == -1;
            }
        }
        return accept;
    }

    abstract void close();

    abstract void reset();
}

