/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.function.adapter.aws.CustomRuntimeEventLoop;
import org.springframework.cloud.function.adapter.aws.FunctionInvoker;
import org.springframework.cloud.function.adapter.aws.LambdaDestinationResolver;
import org.springframework.cloud.function.context.AbstractSpringFunctionAdapterInitializer;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogInitializer;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class CustomRuntimeInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private static Log logger = LogFactory.getLog(CustomRuntimeInitializer.class);

    public void initialize(GenericApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AWS Environment: " + System.getenv()));
        }
        if (!this.isWebExportEnabled(context) && this.isCustomRuntime((Environment)environment)) {
            if (context.getBeanFactory().getBeanNamesForType(CustomRuntimeEventLoop.class, false, false).length == 0) {
                context.registerBean(StringUtils.uncapitalize((String)CustomRuntimeEventLoop.class.getSimpleName()), SmartLifecycle.class, () -> new CustomRuntimeEventLoop((ConfigurableApplicationContext)context), new BeanDefinitionCustomizer[0]);
            }
        } else if (ContextFunctionCatalogInitializer.enabled && ((Boolean)context.getEnvironment().getProperty("spring.functional.enabled", Boolean.class, (Object)false)).booleanValue() && context.getBeanFactory().getBeanNamesForType(DestinationResolver.class, false, false).length == 0) {
            context.registerBean(LambdaDestinationResolver.class, () -> new LambdaDestinationResolver(), new BeanDefinitionCustomizer[0]);
        }
    }

    private boolean isCustomRuntime(Environment environment) {
        String handler = environment.getProperty("_HANDLER");
        if (StringUtils.hasText((String)handler)) {
            handler = handler.split(":")[0];
            logger.info((Object)("AWS Handler: " + handler));
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(handler);
                if (FunctionInvoker.class.isAssignableFrom(clazz) || AbstractSpringFunctionAdapterInitializer.class.isAssignableFrom(clazz)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Will execute Lambda in Custom Runtime");
                return true;
            }
        }
        return false;
    }

    private boolean isWebExportEnabled(GenericApplicationContext context) {
        Boolean enabled = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.web.export.enabled", Boolean.class);
        return enabled != null && enabled != false;
    }
}

