/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.function.adapter.aws.CustomRuntimeAutoConfiguration;
import org.springframework.cloud.function.adapter.aws.LambdaDestinationResolver;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogInitializer;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class CustomRuntimeInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    public void initialize(GenericApplicationContext context) {
        Boolean enabled = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.web.export.enabled", Boolean.class);
        if (enabled == null || !enabled.booleanValue()) {
            return;
        }
        if (ContextFunctionCatalogInitializer.enabled && ((Boolean)context.getEnvironment().getProperty("spring.functional.enabled", Boolean.class, (Object)false)).booleanValue()) {
            if (context.getBeanFactory().getBeanNamesForType(DestinationResolver.class, false, false).length == 0) {
                context.registerBean(LambdaDestinationResolver.class, () -> new LambdaDestinationResolver(), new BeanDefinitionCustomizer[0]);
            }
            context.registerBean(CommandLineRunner.class, () -> args -> CustomRuntimeAutoConfiguration.background(), new BeanDefinitionCustomizer[0]);
        }
    }
}

