/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import java.util.ArrayList;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.adapter.aws.SpringFunctionInitializer;
import reactor.core.publisher.Flux;

public class SpringBootRequestHandler<E, O>
extends SpringFunctionInitializer
implements RequestHandler<E, Object> {
    public SpringBootRequestHandler(Class<?> configurationClass) {
        super(configurationClass);
    }

    public SpringBootRequestHandler() {
    }

    public Object handleRequest(E event, Context context) {
        this.initialize();
        Object input = this.convertEvent(event);
        Publisher<?> output = this.apply((Publisher<?>)this.extract(input));
        return this.result(input, output);
    }

    private Object result(Object input, Publisher<?> output) {
        ArrayList<O> result = new ArrayList<O>();
        for (Object value : Flux.from(output).toIterable()) {
            result.add(this.convertOutput(value));
        }
        if (this.isSingleValue(input) && result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    private boolean isSingleValue(Object input) {
        return !(input instanceof Collection);
    }

    private Flux<?> extract(Object input) {
        if (input instanceof Collection) {
            return Flux.fromIterable((Iterable)((Iterable)input));
        }
        return Flux.just((Object)input);
    }

    protected Object convertEvent(E event) {
        return event;
    }

    protected O convertOutput(Object output) {
        return (O)output;
    }
}

