/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.ActuatorOperations;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalActuatorTemplate;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.local.LocalTaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={LocalDeployerProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class LocalDeployerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AppDeployer.class})
    public AppDeployer appDeployer(LocalDeployerProperties properties) {
        return new LocalAppDeployer(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskLauncher.class})
    public TaskLauncher taskLauncher(LocalDeployerProperties properties) {
        return new LocalTaskLauncher(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    RestTemplate actuatorRestTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean(value={ActuatorOperations.class})
    ActuatorOperations actuatorOperations(RestTemplate actuatorRestTemplate, AppDeployer appDeployer, LocalDeployerProperties properties) {
        return new LocalActuatorTemplate(actuatorRestTemplate, appDeployer, properties.getAppAdmin());
    }
}

