/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.CommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.util.StringUtils;

class ReadinessCommandProbeCreator
extends CommandProbeCreator {
    ReadinessCommandProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Command", "ProbeDelay", this.getKubernetesDeployerProperties().getReadinessCommandProbeDelay());
    }

    @Override
    int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Command", "ProbePeriod", this.getKubernetesDeployerProperties().getReadinessCommandProbePeriod());
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Command", "ProbeFailure", this.getKubernetesDeployerProperties().getReadinessCommandProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Command", "ProbeSuccess", this.getKubernetesDeployerProperties().getReadinessCommandProbeSuccess());
    }

    @Override
    String[] getCommand() {
        String probeCommandValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.readinessCommandProbeCommand");
        if (StringUtils.hasText((String)probeCommandValue)) {
            return new CommandLineTokenizer(probeCommandValue).getArgs().toArray(new String[0]);
        }
        if (this.getKubernetesDeployerProperties().getReadinessCommandProbeCommand() != null) {
            return new CommandLineTokenizer(this.getKubernetesDeployerProperties().getReadinessCommandProbeCommand()).getArgs().toArray(new String[0]);
        }
        throw new IllegalArgumentException("The readinessCommandProbeCommand property must be set.");
    }
}

