/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.TcpProbeCreator;
import org.springframework.util.StringUtils;

class LivenessTcpProbeCreator
extends TcpProbeCreator {
    LivenessTcpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Tcp", "ProbeDelay", this.getKubernetesDeployerProperties().getLivenessTcpProbeDelay());
    }

    @Override
    int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Tcp", "ProbePeriod", this.getKubernetesDeployerProperties().getLivenessTcpProbePeriod());
    }

    @Override
    protected int getTimeout() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Tcp", "ProbeTimeout", this.getKubernetesDeployerProperties().getLivenessTcpProbeTimeout());
    }

    @Override
    Integer getPort() {
        String probePortValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.liveness", "Tcp", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("LivenessTcpProbePort must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getLivenessTcpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getLivenessTcpProbePort();
        }
        throw new IllegalArgumentException("The livenessTcpProbePort property must be set.");
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Tcp", "ProbeFailure", this.getKubernetesDeployerProperties().getLivenessTcpProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Tcp", "ProbeSuccess", this.getKubernetesDeployerProperties().getLivenessTcpProbeSuccess());
    }
}

