/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeAuthenticationType;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class HttpProbeCreator
extends ProbeCreator {
    private static final int BOOT_1_MAJOR_VERSION = 1;
    static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    static final String PROBE_CREDENTIALS_SECRET_KEY_NAME = "credentials";
    static final String BOOT_1_READINESS_PROBE_PATH = "/info";
    static final String BOOT_1_LIVENESS_PROBE_PATH = "/health";
    static final String BOOT_2_READINESS_PROBE_PATH = "/actuator/info";
    static final String BOOT_2_LIVENESS_PROBE_PATH = "/actuator/health";
    static final String DEFAULT_PROBE_SCHEME = "HTTP";

    HttpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    protected abstract String getProbePath();

    protected abstract Integer getPort();

    protected abstract String getScheme();

    protected abstract int getTimeout();

    @Override
    protected Probe create() {
        HTTPGetActionBuilder httpGetActionBuilder = (HTTPGetActionBuilder)((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath(this.getProbePath())).withNewPort(this.getPort())).withScheme(this.getScheme());
        List<HTTPHeader> httpHeaders = this.getHttpHeaders();
        if (!httpHeaders.isEmpty()) {
            httpGetActionBuilder.withHttpHeaders(httpHeaders);
        }
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withHttpGet(httpGetActionBuilder.build())).withTimeoutSeconds(Integer.valueOf(this.getTimeout()))).withInitialDelaySeconds(Integer.valueOf(this.getInitialDelay()))).withPeriodSeconds(Integer.valueOf(this.getPeriod()))).withFailureThreshold(Integer.valueOf(this.getFailure()))).withSuccessThreshold(Integer.valueOf(this.getSuccess()))).build();
    }

    private List<HTTPHeader> getHttpHeaders() {
        ArrayList<HTTPHeader> httpHeaders = new ArrayList<HTTPHeader>();
        HTTPHeader authenticationHeader = this.getAuthorizationHeader();
        if (authenticationHeader != null) {
            httpHeaders.add(authenticationHeader);
        }
        return httpHeaders;
    }

    private HTTPHeader getAuthorizationHeader() {
        HTTPHeader httpHeader = null;
        Secret probeCredentialsSecret = this.getContainerConfiguration().getProbeCredentialsSecret();
        if (probeCredentialsSecret != null) {
            Assert.isTrue((boolean)probeCredentialsSecret.getData().containsKey(PROBE_CREDENTIALS_SECRET_KEY_NAME), (String)"Secret does not contain a key by the name of credentials");
            httpHeader = new HTTPHeader();
            httpHeader.setName(AUTHORIZATION_HEADER_NAME);
            httpHeader.setValue(ProbeAuthenticationType.Basic.name() + " " + (String)probeCredentialsSecret.getData().get(PROBE_CREDENTIALS_SECRET_KEY_NAME));
        }
        return httpHeader;
    }

    Integer getDefaultPort() {
        return this.getContainerConfiguration().getExternalPort();
    }

    boolean useBoot1ProbePath() {
        String bootMajorVersionProperty = "spring.cloud.deployer.kubernetes.bootMajorVersion";
        String bootMajorVersionValue = this.getDeploymentPropertyValue(bootMajorVersionProperty);
        if (StringUtils.hasText((String)bootMajorVersionValue)) {
            return Integer.parseInt(bootMajorVersionValue) == 1;
        }
        return false;
    }
}

