/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.HttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.util.StringUtils;

class LivenessHttpProbeCreator
extends HttpProbeCreator {
    LivenessHttpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.liveness", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getLivenessHttpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getLivenessHttpProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.liveness", "ProbePath");
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.getKubernetesDeployerProperties().getLivenessHttpProbePath() != null) {
            return this.getKubernetesDeployerProperties().getLivenessHttpProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/health";
        }
        return "/actuator/health";
    }

    @Override
    protected String getScheme() {
        String probeSchemeValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.liveness", "ProbeScheme");
        if (StringUtils.hasText((String)probeSchemeValue)) {
            return probeSchemeValue;
        }
        if (this.getKubernetesDeployerProperties().getLivenessHttpProbeScheme() != null) {
            return this.getKubernetesDeployerProperties().getLivenessHttpProbeScheme();
        }
        return "HTTP";
    }

    @Override
    protected int getTimeout() {
        String probeTimeoutValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.liveness", "ProbeTimeout");
        if (StringUtils.hasText((String)probeTimeoutValue)) {
            return Integer.valueOf(probeTimeoutValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessHttpProbeTimeout();
    }

    @Override
    protected int getInitialDelay() {
        String probeDelayValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.liveness", "ProbeDelay");
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessHttpProbeDelay();
    }

    @Override
    protected int getPeriod() {
        String probePeriodValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.liveness", "ProbePeriod");
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessHttpProbePeriod();
    }
}

