/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.client.Config;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;

@ConfigurationProperties(prefix="spring.cloud.deployer.kubernetes")
public class KubernetesDeployerProperties {
    public static final String KUBERNETES_DEPLOYMENT_NODE_SELECTOR = "spring.cloud.deployer.kubernetes.deployment.nodeSelector";
    private int maximumConcurrentTasks = 20;
    @NestedConfigurationProperty
    private Config fabric8 = Config.autoConfigure(null);
    private static String KUBERNETES_NAMESPACE = System.getenv("KUBERNETES_NAMESPACE");
    private String namespace = KUBERNETES_NAMESPACE;
    private String imagePullSecret;
    private int livenessProbeDelay = 10;
    private int livenessProbePeriod = 60;
    private int livenessProbeTimeout = 2;
    private String livenessProbePath;
    private Integer livenessProbePort = null;
    private int readinessProbeDelay = 10;
    private int readinessProbePeriod = 10;
    private int readinessProbeTimeout = 2;
    private String readinessProbePath;
    private Integer readinessProbePort = null;
    private String probeCredentialsSecret;
    private LimitsResources limits = new LimitsResources();
    private RequestsResources requests = new RequestsResources();
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private StatefulSet statefulSet = new StatefulSet();
    private String[] environmentVariables = new String[0];
    private EntryPointStyle entryPointStyle = EntryPointStyle.exec;
    private boolean createLoadBalancer = false;
    private String serviceAnnotations = null;
    private String podAnnotations;
    private String jobAnnotations;
    private int minutesToWaitForLoadBalancer = 5;
    private int maxTerminatedErrorRestarts = 2;
    private int maxCrashLoopBackOffRestarts = 4;
    private ImagePullPolicy imagePullPolicy = ImagePullPolicy.IfNotPresent;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();
    private boolean hostNetwork = false;
    private boolean createJob = false;
    private String deploymentServiceAccountName;

    public Config getFabric8() {
        return this.fabric8;
    }

    public void setFabric8(Config fabric8) {
        this.fabric8 = fabric8;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public void setImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
    }

    public int getLivenessProbeDelay() {
        return this.livenessProbeDelay;
    }

    public void setLivenessProbeDelay(int livenessProbeDelay) {
        this.livenessProbeDelay = livenessProbeDelay;
    }

    public int getLivenessProbePeriod() {
        return this.livenessProbePeriod;
    }

    public void setLivenessProbePeriod(int livenessProbePeriod) {
        this.livenessProbePeriod = livenessProbePeriod;
    }

    public int getLivenessProbeTimeout() {
        return this.livenessProbeTimeout;
    }

    public void setLivenessProbeTimeout(int livenessProbeTimeout) {
        this.livenessProbeTimeout = livenessProbeTimeout;
    }

    public String getLivenessProbePath() {
        return this.livenessProbePath;
    }

    public Integer getLivenessProbePort() {
        return this.livenessProbePort;
    }

    public void setLivenessProbePort(Integer livenessProbePort) {
        this.livenessProbePort = livenessProbePort;
    }

    public void setLivenessProbePath(String livenessProbePath) {
        this.livenessProbePath = livenessProbePath;
    }

    public int getReadinessProbeDelay() {
        return this.readinessProbeDelay;
    }

    public void setReadinessProbeDelay(int readinessProbeDelay) {
        this.readinessProbeDelay = readinessProbeDelay;
    }

    public int getReadinessProbePeriod() {
        return this.readinessProbePeriod;
    }

    public void setReadinessProbePeriod(int readinessProbePeriod) {
        this.readinessProbePeriod = readinessProbePeriod;
    }

    public int getReadinessProbeTimeout() {
        return this.readinessProbeTimeout;
    }

    public void setReadinessProbeTimeout(int readinessProbeTimeout) {
        this.readinessProbeTimeout = readinessProbeTimeout;
    }

    public String getReadinessProbePath() {
        return this.readinessProbePath;
    }

    public void setReadinessProbePath(String readinessProbePath) {
        this.readinessProbePath = readinessProbePath;
    }

    public Integer getReadinessProbePort() {
        return this.readinessProbePort;
    }

    public void setReadinessProbePort(Integer readinessProbePort) {
        this.readinessProbePort = readinessProbePort;
    }

    public String getProbeCredentialsSecret() {
        return this.probeCredentialsSecret;
    }

    public void setProbeCredentialsSecret(String probeCredentialsSecret) {
        this.probeCredentialsSecret = probeCredentialsSecret;
    }

    public StatefulSet getStatefulSet() {
        return this.statefulSet;
    }

    public void setStatefulSet(StatefulSet statefulSet) {
        this.statefulSet = statefulSet;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    public String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(String[] environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public EntryPointStyle getEntryPointStyle() {
        return this.entryPointStyle;
    }

    public void setEntryPointStyle(EntryPointStyle entryPointStyle) {
        this.entryPointStyle = entryPointStyle;
    }

    public boolean isCreateLoadBalancer() {
        return this.createLoadBalancer;
    }

    public void setCreateLoadBalancer(boolean createLoadBalancer) {
        this.createLoadBalancer = createLoadBalancer;
    }

    public String getServiceAnnotations() {
        return this.serviceAnnotations;
    }

    public void setServiceAnnotations(String serviceAnnotations) {
        this.serviceAnnotations = serviceAnnotations;
    }

    public String getPodAnnotations() {
        return this.podAnnotations;
    }

    public void setPodAnnotations(String podAnnotations) {
        this.podAnnotations = podAnnotations;
    }

    public String getJobAnnotations() {
        return this.jobAnnotations;
    }

    public void setJobAnnotations(String jobAnnotations) {
        this.jobAnnotations = jobAnnotations;
    }

    public int getMinutesToWaitForLoadBalancer() {
        return this.minutesToWaitForLoadBalancer;
    }

    public void setMinutesToWaitForLoadBalancer(int minutesToWaitForLoadBalancer) {
        this.minutesToWaitForLoadBalancer = minutesToWaitForLoadBalancer;
    }

    public int getMaxTerminatedErrorRestarts() {
        return this.maxTerminatedErrorRestarts;
    }

    public void setMaxTerminatedErrorRestarts(int maxTerminatedErrorRestarts) {
        this.maxTerminatedErrorRestarts = maxTerminatedErrorRestarts;
    }

    public int getMaxCrashLoopBackOffRestarts() {
        return this.maxCrashLoopBackOffRestarts;
    }

    public void setMaxCrashLoopBackOffRestarts(int maxCrashLoopBackOffRestarts) {
        this.maxCrashLoopBackOffRestarts = maxCrashLoopBackOffRestarts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public LimitsResources getLimits() {
        return this.limits;
    }

    public void setLimits(LimitsResources limits) {
        this.limits = limits;
    }

    public RequestsResources getRequests() {
        return this.requests;
    }

    public void setRequests(RequestsResources requests) {
        this.requests = requests;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    public boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    public boolean isCreateJob() {
        return this.createJob;
    }

    public void setCreateJob(boolean createJob) {
        this.createJob = createJob;
    }

    public String getDeploymentServiceAccountName() {
        return this.deploymentServiceAccountName;
    }

    public void setDeploymentServiceAccountName(String deploymentServiceAccountName) {
        this.deploymentServiceAccountName = deploymentServiceAccountName;
    }

    public int getMaximumConcurrentTasks() {
        return this.maximumConcurrentTasks;
    }

    public void setMaximumConcurrentTasks(int maximumConcurrentTasks) {
        this.maximumConcurrentTasks = maximumConcurrentTasks;
    }

    public static class Toleration {
        private String effect;
        private String key;
        private String operator;
        private Long tolerationSeconds;
        private String value;

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public Long getTolerationSeconds() {
            return this.tolerationSeconds;
        }

        public void setTolerationSeconds(Long tolerationSeconds) {
            this.tolerationSeconds = tolerationSeconds;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class StatefulSet {
        private VolumeClaimTemplate volumeClaimTemplate = new VolumeClaimTemplate();

        public VolumeClaimTemplate getVolumeClaimTemplate() {
            return this.volumeClaimTemplate;
        }

        public void setVolumeClaimTemplate(VolumeClaimTemplate volumeClaimTemplate) {
            this.volumeClaimTemplate = volumeClaimTemplate;
        }

        public static class VolumeClaimTemplate {
            private String storage = "10m";
            private String storageClassName;

            public String getStorage() {
                return this.storage;
            }

            public void setStorage(String storage) {
                this.storage = storage;
            }

            public String getStorageClassName() {
                return this.storageClassName;
            }

            public void setStorageClassName(String storageClassName) {
                this.storageClassName = storageClassName;
            }
        }
    }

    public static class RequestsResources {
        private String cpu;
        private String memory;

        public RequestsResources() {
        }

        public RequestsResources(String cpu, String memory) {
            this.cpu = cpu;
            this.memory = memory;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public String getMemory() {
            return this.memory;
        }

        public void setMemory(String memory) {
            this.memory = memory;
        }
    }

    public static class LimitsResources {
        private String cpu;
        private String memory;

        public LimitsResources() {
        }

        public LimitsResources(String cpu, String memory) {
            this.cpu = cpu;
            this.memory = memory;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public String getMemory() {
            return this.memory;
        }

        public void setMemory(String memory) {
            this.memory = memory;
        }
    }
}

