/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.kubernetes.RunningPhaseDeploymentStateResolver;

class CompositeDeploymentStateResolver
implements RunningPhaseDeploymentStateResolver {
    private final RunningPhaseDeploymentStateResolver[] delegates;

    CompositeDeploymentStateResolver(RunningPhaseDeploymentStateResolver ... delegates) {
        this.delegates = delegates;
    }

    @Override
    public DeploymentState resolve(ContainerStatus containerStatus) {
        for (RunningPhaseDeploymentStateResolver resolver : this.delegates) {
            DeploymentState deploymentState = resolver.resolve(containerStatus);
            if (deploymentState == null) continue;
            return deploymentState;
        }
        return null;
    }
}

