/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.util;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.cloud.dataflow.rest.util.CheckableResource;
import org.springframework.core.io.AbstractResource;

public class ProcessOutputResource
extends AbstractResource
implements CheckableResource {
    private final ProcessBuilder processBuilder;
    private final Object monitor = new Object();
    private Process process;

    public ProcessOutputResource(String ... command) {
        this.processBuilder = new ProcessBuilder(command);
    }

    public String getDescription() {
        return this.processBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.process = this.processBuilder.start();
        }
        return this.process.getInputStream();
    }

    public String toString() {
        return this.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            int exitStatusCode;
            if (this.process != null && !this.process.isAlive() && (exitStatusCode = this.process.exitValue()) != 0) {
                throw new IOException(String.format("Command for resource %s failed with exit status code %d", this.toString(), exitStatusCode));
            }
        }
    }
}

