/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public final class DeploymentPropertiesUtils {
    private static final Pattern DEPLOYMENT_PARAMS_PATTERN = Pattern.compile("(\\s(?=([^\\\"']*[\\\"'][^\\\"']*[\\\"'])*[^\\\"']*$))");

    private DeploymentPropertiesUtils() {
    }

    public static Map<String, String> parse(String s) {
        LinkedHashMap<String, String> deploymentProperties = new LinkedHashMap<String, String>();
        List<String> pairs = DeploymentPropertiesUtils.parseParamList(s, ",");
        for (String pair : pairs) {
            DeploymentPropertiesUtils.addKeyValuePairAsProperty(pair, deploymentProperties);
        }
        return deploymentProperties;
    }

    public static List<String> parseParamList(String s, String delimiter) {
        ArrayList<String> pairs = new ArrayList<String>();
        String[] candidates = StringUtils.delimitedListToStringArray((String)s, (String)delimiter);
        for (int i = 0; i < candidates.length; ++i) {
            if (i > 0 && !candidates[i].contains("=")) {
                pairs.set(pairs.size() - 1, pairs.get(pairs.size() - 1) + delimiter + candidates[i]);
                continue;
            }
            pairs.add(candidates[i]);
        }
        return pairs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> parseDeploymentProperties(String deploymentProperties, File propertiesFile, int which) throws IOException {
        switch (which) {
            case 0: {
                return DeploymentPropertiesUtils.parse(deploymentProperties);
            }
            case 1: {
                String extension = FilenameUtils.getExtension((String)propertiesFile.getName());
                Properties props = null;
                if (extension.equals("yaml") || extension.equals("yml")) {
                    YamlPropertiesFactoryBean yamlPropertiesFactoryBean = new YamlPropertiesFactoryBean();
                    yamlPropertiesFactoryBean.setResources(new Resource[]{new FileSystemResource(propertiesFile)});
                    yamlPropertiesFactoryBean.afterPropertiesSet();
                    props = yamlPropertiesFactoryBean.getObject();
                    return DeploymentPropertiesUtils.convert(props);
                }
                props = new Properties();
                try (FileInputStream fis = new FileInputStream(propertiesFile);){
                    props.load(fis);
                    return DeploymentPropertiesUtils.convert(props);
                }
            }
            case -1: {
                return new HashMap<String, String>(1);
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static void validateDeploymentProperties(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String key = property.getKey();
            if (key.startsWith("app.") || key.startsWith("deployer.") || key.startsWith("scheduler.")) continue;
            throw new IllegalArgumentException("Only deployment property keys starting with 'app.', 'deployer.' or, 'scheduler.' allowed, got '" + key + "'");
        }
    }

    public static void validateSkipperDeploymentProperties(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String key = property.getKey();
            if (key.startsWith("app.") || key.startsWith("deployer.") || key.startsWith("version.")) continue;
            throw new IllegalArgumentException("Only deployment property keys starting with 'app.' or 'deployer.'  or 'version.' allowed, got '" + key + "'");
        }
    }

    public static Map<String, String> extractAndQualifyDeployerProperties(Map<String, String> input, String appName) {
        String wildcardPrefix = "deployer.*.";
        int wildcardLength = "deployer.*.".length();
        String appPrefix = String.format("deployer.%s.", appName);
        int appLength = appPrefix.length();
        Map<String, String> result = new TreeMap<String, String>(input).entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith("deployer.*.") || ((String)kv.getKey()).startsWith(appPrefix)).collect(Collectors.toMap(kv -> ((String)kv.getKey()).startsWith("deployer.*.") ? "spring.cloud.deployer." + ((String)kv.getKey()).substring(wildcardLength) : "spring.cloud.deployer." + ((String)kv.getKey()).substring(appLength), kv -> (String)kv.getValue(), (fromWildcard, fromApp) -> fromApp));
        return result;
    }

    public static Map<String, String> qualifyDeployerProperties(Map<String, String> input, String appName) {
        String wildcardPrefix = "deployer.*.";
        int wildcardLength = "deployer.*.".length();
        String appPrefix = String.format("deployer.%s.", appName);
        int appLength = appPrefix.length();
        Map<String, String> resultDeployer = new TreeMap<String, String>(input).entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith("deployer.*.") || ((String)kv.getKey()).startsWith(appPrefix)).collect(Collectors.toMap(kv -> ((String)kv.getKey()).startsWith("deployer.*.") ? "spring.cloud.deployer." + ((String)kv.getKey()).substring(wildcardLength) : "spring.cloud.deployer." + ((String)kv.getKey()).substring(appLength), kv -> (String)kv.getValue(), (fromWildcard, fromApp) -> fromApp));
        Map<String, String> resultApp = new TreeMap<String, String>(input).entrySet().stream().filter(kv -> !((String)kv.getKey()).startsWith("deployer.*.") && !((String)kv.getKey()).startsWith(appPrefix)).collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> (String)kv.getValue(), (fromWildcard, fromApp) -> fromApp));
        resultDeployer.putAll(resultApp);
        return resultDeployer;
    }

    public static String format(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder(15 * properties.size());
        for (Map.Entry<String, String> pair : properties.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pair.getKey()).append("=").append(pair.getValue());
        }
        return sb.toString();
    }

    public static Map<String, String> convert(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.put(key, properties.getProperty(key));
        }
        return result;
    }

    private static void addKeyValuePairAsProperty(String pair, Map<String, String> properties) {
        int firstEquals = pair.indexOf(61);
        if (firstEquals != -1) {
            properties.put(pair.substring(0, firstEquals).trim(), pair.substring(firstEquals + 1).trim());
        }
    }

    public static List<String> removeQuoting(List<String> params) {
        ArrayList<String> paramsToUse = new ArrayList<String>();
        if (params != null) {
            for (String param : params) {
                String p;
                Matcher regexMatcher = DEPLOYMENT_PARAMS_PATTERN.matcher(param);
                int start = 0;
                while (regexMatcher.find()) {
                    p = DeploymentPropertiesUtils.removeQuoting(param.substring(start, regexMatcher.start()).trim());
                    if (StringUtils.hasText((String)p)) {
                        paramsToUse.add(p);
                    }
                    start = regexMatcher.start();
                }
                if (param == null || param.length() <= 0 || !StringUtils.hasText((String)(p = DeploymentPropertiesUtils.removeQuoting(param.substring(start, param.length()).trim())))) continue;
                paramsToUse.add(p);
            }
        }
        return paramsToUse;
    }

    private static String removeQuoting(String param) {
        String[] split;
        param = DeploymentPropertiesUtils.removeQuote(param, '\'');
        if (StringUtils.hasText((String)(param = DeploymentPropertiesUtils.removeQuote(param, '\"'))) && (split = param.split("=", 2)).length == 2) {
            String value = DeploymentPropertiesUtils.removeQuote(split[1], '\'');
            value = DeploymentPropertiesUtils.removeQuote(value, '\"');
            param = split[0] + "=" + value;
        }
        return param;
    }

    private static String removeQuote(String param, char c) {
        if (param != null && param.length() > 1 && param.charAt(0) == c && param.charAt(param.length() - 1) == c) {
            param = param.substring(1, param.length() - 1);
        }
        return param;
    }
}

