/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.dataflow.rest.util.CheckableResource;
import org.springframework.util.StreamUtils;

public class ResourceBasedAuthorizationInterceptor
implements HttpRequestInterceptor {
    private final CheckableResource resource;

    public ResourceBasedAuthorizationInterceptor(CheckableResource resource) {
        this.resource = resource;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        String credentials = StreamUtils.copyToString((InputStream)this.resource.getInputStream(), (Charset)StandardCharsets.UTF_8).trim();
        this.resource.check();
        httpRequest.addHeader("Authorization", credentials);
    }
}

