/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.audit.service.AuditRecordService;
import org.springframework.cloud.dataflow.audit.service.AuditServiceUtils;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.AuditActionType;
import org.springframework.cloud.dataflow.core.AuditOperationType;
import org.springframework.cloud.dataflow.registry.repository.AppRegistrationRepository;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;
import org.springframework.cloud.dataflow.registry.support.AppResourceCommon;
import org.springframework.cloud.dataflow.registry.support.NoSuchAppRegistrationException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Transactional
public class DefaultAppRegistryService
implements AppRegistryService {
    public static final String METADATA_KEY_SUFFIX = "metadata";
    protected static final Logger logger = LoggerFactory.getLogger(DefaultAppRegistryService.class);
    private final AppRegistrationRepository appRegistrationRepository;
    private AppResourceCommon appResourceCommon;
    protected final AuditRecordService auditRecordService;
    protected final AuditServiceUtils auditServiceUtils;

    public DefaultAppRegistryService(AppRegistrationRepository appRegistrationRepository, AppResourceCommon appResourceCommon, AuditRecordService auditRecordService) {
        Assert.notNull((Object)appResourceCommon, (String)"'appResourceCommon' must not be null");
        Assert.notNull((Object)appRegistrationRepository, (String)"'appRegistrationRepository' must not be null");
        Assert.notNull((Object)auditRecordService, (String)"'auditRecordService' must not be null");
        this.appResourceCommon = appResourceCommon;
        this.appRegistrationRepository = appRegistrationRepository;
        this.auditRecordService = auditRecordService;
        this.auditServiceUtils = new AuditServiceUtils();
    }

    @Override
    public AppRegistration find(String name, ApplicationType type) {
        return this.getDefaultApp(name, type);
    }

    @Override
    public AppRegistration find(String name, ApplicationType type, String version) {
        return this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(name, type, version);
    }

    @Override
    public AppRegistration getDefaultApp(String name, ApplicationType type) {
        return this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndDefaultVersionIsTrue(name, type);
    }

    @Override
    public void validate(AppRegistration registration, String uri, String version) {
        String newAppUriNoVersion;
        String defaultAppUri;
        String defaultAppUriNoVersion;
        if (registration != null && StringUtils.hasText((String)version) && !ObjectUtils.nullSafeEquals((Object)(defaultAppUriNoVersion = DefaultAppRegistryService.removeLastMatch(defaultAppUri = registration.getUri().toString(), registration.getVersion())), (Object)(newAppUriNoVersion = DefaultAppRegistryService.removeLastMatch(uri, version)))) {
            throw new IllegalArgumentException("Existing default application [" + defaultAppUri + "] can only differ by a version but is [" + uri + "]");
        }
    }

    private static String removeLastMatch(String original, String match) {
        StringBuilder builder = new StringBuilder();
        int start = original.lastIndexOf(match);
        builder.append(original.substring(0, start));
        builder.append(original.substring(start + match.length()));
        return builder.toString();
    }

    @Override
    public void setDefaultApp(String name, ApplicationType type, String version) {
        AppRegistration newDefault;
        AppRegistration oldDefault = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndDefaultVersionIsTrue(name, type);
        if (oldDefault != null) {
            oldDefault.setDefaultVersion(Boolean.valueOf(false));
            this.appRegistrationRepository.save(oldDefault);
        }
        if ((newDefault = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(name, type, version)) == null) {
            throw new NoSuchAppRegistrationException(name, type, version);
        }
        newDefault.setDefaultVersion(Boolean.valueOf(true));
        this.appRegistrationRepository.save(newDefault);
        this.auditRecordService.populateAndSaveAuditRecordUsingMapData(AuditOperationType.APP_REGISTRATION, AuditActionType.UPDATE, newDefault.getName(), this.auditServiceUtils.convertAppRegistrationToAuditData(newDefault), null);
    }

    @Override
    public List<AppRegistration> findAll() {
        return this.appRegistrationRepository.findAll();
    }

    @Override
    public Page<AppRegistration> findAllByTypeAndNameIsLike(ApplicationType type, String name, Pageable pageable) {
        Page<AppRegistration> result = null;
        result = !StringUtils.hasText((String)name) && type == null ? this.findAll(pageable) : (StringUtils.hasText((String)name) && type == null ? this.appRegistrationRepository.findAllByNameContainingIgnoreCase(name, pageable) : (StringUtils.hasText((String)name) ? this.appRegistrationRepository.findAllByTypeAndNameContainingIgnoreCase(type, name, pageable) : this.appRegistrationRepository.findAllByType(type, pageable)));
        return result;
    }

    @Override
    public Page<AppRegistration> findAll(Pageable pageable) {
        return this.appRegistrationRepository.findAll(pageable);
    }

    @Override
    public AppRegistration save(String name, ApplicationType type, String version, URI uri, URI metadataUri) {
        return this.save(new AppRegistration(name, type, version, uri, metadataUri));
    }

    @Override
    public AppRegistration save(AppRegistration app) {
        AppRegistration createdApp;
        AppRegistration appRegistration = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(app.getName(), app.getType(), app.getVersion());
        if (appRegistration != null) {
            appRegistration.setUri(app.getUri());
            appRegistration.setMetadataUri(app.getMetadataUri());
            createdApp = this.appRegistrationRepository.save(appRegistration);
            this.populateAuditData(AuditActionType.UPDATE, createdApp);
        } else {
            if (this.getDefaultApp(app.getName(), app.getType()) == null) {
                app.setDefaultVersion(Boolean.valueOf(true));
            }
            createdApp = this.appRegistrationRepository.save(app);
            this.populateAuditData(AuditActionType.CREATE, createdApp);
        }
        return createdApp;
    }

    private void populateAuditData(AuditActionType auditActionType, AppRegistration appRegistration) {
        if (appRegistration == null) {
            logger.error("App registration failed, app not saved into database!");
        } else {
            this.auditRecordService.populateAndSaveAuditRecordUsingMapData(AuditOperationType.APP_REGISTRATION, auditActionType, appRegistration.getName(), this.auditServiceUtils.convertAppRegistrationToAuditData(appRegistration), null);
        }
    }

    @Override
    public void delete(String name, ApplicationType type, String version) {
        this.appRegistrationRepository.deleteAppRegistrationByNameAndTypeAndVersion(name, type, version);
        this.populateAuditData(AuditActionType.DELETE, new AppRegistration(name, type, version, URI.create(""), URI.create("")));
    }

    @Override
    public void deleteAll(Iterable<AppRegistration> appRegistrations) {
        this.appRegistrationRepository.deleteAll(appRegistrations);
    }

    protected boolean isOverwrite(AppRegistration app, boolean overwrite) {
        return overwrite || this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(app.getName(), app.getType(), app.getVersion()) == null;
    }

    @Override
    public boolean appExist(String name, ApplicationType type) {
        return this.getDefaultApp(name, type) != null;
    }

    @Override
    public boolean appExist(String name, ApplicationType type, String version) {
        return this.find(name, type, version) != null;
    }

    @Override
    public Resource getAppResource(AppRegistration appRegistration) {
        return this.appResourceCommon.getResource(appRegistration.getUri().toString());
    }

    @Override
    public Resource getAppMetadataResource(AppRegistration appRegistration) {
        return this.appResourceCommon.getMetadataResource(appRegistration.getUri(), appRegistration.getMetadataUri());
    }

    @Override
    public String getResourceVersion(Resource resource) {
        return this.appResourceCommon.getResourceVersion(resource);
    }

    @Override
    public String getResourceWithoutVersion(Resource resource) {
        return this.appResourceCommon.getResourceWithoutVersion(resource);
    }

    @Override
    public String getResourceVersion(String uriString) {
        return this.getResourceVersion(this.appResourceCommon.getResource(uriString));
    }

    protected Properties loadProperties(Resource resource) {
        try {
            return PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from " + resource.getDescription(), e);
        }
    }

    protected URI warnOnMalformedURI(String key, URI uri) {
        if (StringUtils.isEmpty((Object)uri)) {
            logger.warn(String.format("Error when registering '%s': URI is required", key));
        } else if (!StringUtils.hasText((String)uri.getScheme())) {
            logger.warn(String.format("Error when registering '%s' with URI %s: URI scheme must be specified", key, uri));
        } else if (!StringUtils.hasText((String)uri.getSchemeSpecificPart())) {
            logger.warn(String.format("Error when registering '%s' with URI %s: URI scheme-specific part must be specified", key, uri));
        }
        return uri;
    }

    @Override
    public List<AppRegistration> importAll(boolean overwrite, Resource ... resources) {
        ArrayList<AppRegistration> registrations = new ArrayList<AppRegistration>();
        ((Stream)Stream.of(resources).parallel()).flatMap(this::resourceAsLines).flatMap(this::splitValidLines).reduce(new HashMap(), this.reduceToAppRegistrations(), (left, right) -> {
            left.putAll(right);
            return left;
        }).values().stream().filter(ar -> ar.getUri() != null).filter(ar -> this.isOverwrite((AppRegistration)ar, overwrite)).map(ar -> {
            this.save((AppRegistration)ar);
            registrations.add((AppRegistration)ar);
            return ar;
        }).collect(Collectors.toList());
        return registrations;
    }

    private BiFunction<HashMap<String, AppRegistration>, ? super String[], HashMap<String, AppRegistration>> reduceToAppRegistrations() {
        return (map, lineSplit) -> {
            String[] typeName = lineSplit[0].split("\\.");
            if (typeName.length < 2 || typeName.length > 3) {
                throw new IllegalArgumentException("Invalid format for app key '" + lineSplit[0] + "'in file. Must be <type>.<name> or <type>.<name>.metadata");
            }
            String type = typeName[0].trim();
            String name = typeName[1].trim();
            String version = this.getResourceVersion(lineSplit[1]);
            String key = type + name + version;
            if (!map.containsKey(key) && map.containsKey(type + name + "latest")) {
                key = type + name + "latest";
            }
            AppRegistration ar = map.getOrDefault(key, new AppRegistration());
            ar.setName(name);
            ar.setType(ApplicationType.valueOf((String)type));
            ar.setVersion(version);
            if (typeName.length == 2) {
                try {
                    ar.setUri(new URI(lineSplit[1]));
                    this.warnOnMalformedURI(lineSplit[0], ar.getUri());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (typeName.length == 3) {
                try {
                    ar.setMetadataUri(new URI(lineSplit[1]));
                    this.warnOnMalformedURI(lineSplit[0], ar.getMetadataUri());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            map.put(key, ar);
            return map;
        };
    }

    private Stream<String> resourceAsLines(Resource resource) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            return bufferedReader.lines();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading from " + resource.getDescription(), e);
        }
    }

    /*
     * Exception decompiling
     */
    private Stream<String[]> splitValidLines(String line) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Predicate<String> skipCommentLines() {
        return line -> line != null && StringUtils.hasText((String)line) && (!line.startsWith("#") || !line.startsWith("/"));
    }
}

