/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.support;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.dataflow.registry.support.DockerImage;
import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.resource.support.DownloadingUrlResourceLoader;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AppResourceCommon {
    private MavenProperties mavenProperties;
    private ResourceLoader metadataResourceLoader;

    public AppResourceCommon(MavenProperties mavenProperties, ResourceLoader resourceLoader) {
        Assert.notNull((Object)mavenProperties, (String)"Non null Maven Properties are required!");
        this.mavenProperties = mavenProperties;
        this.metadataResourceLoader = resourceLoader;
    }

    public String getResourceVersion(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource must not be null");
        if (resource instanceof MavenResource) {
            MavenResource mavenResource = (MavenResource)resource;
            return mavenResource.getVersion();
        }
        if (resource instanceof DockerResource) {
            DockerResource dockerResource = (DockerResource)resource;
            return this.getDockerImageTag(dockerResource);
        }
        if (resource instanceof UrlResource) {
            return this.getUrlResourceVersion((UrlResource)resource);
        }
        throw new IllegalArgumentException("Do not support extracting resource from Resource of type " + resource.getClass().getSimpleName());
    }

    private String getDockerImageTag(DockerResource dockerResource) {
        try {
            String uri = dockerResource.getURI().toString().substring("docker:".length());
            DockerImage dockerImage = DockerImage.fromImageName(uri);
            String tag = dockerImage.getTag();
            Assert.isTrue((boolean)StringUtils.hasText((String)tag), (String)("Could not extract tag from " + dockerResource.getDescription()));
            return tag;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Docker Resource URI is not in expected format to extract version. " + dockerResource.getDescription(), e);
        }
    }

    String getUrlResourceVersion(UrlResource urlResource) {
        Matcher m = this.getMatcher(urlResource);
        return m.group(2) + m.group(3);
    }

    private Matcher getMatcher(UrlResource urlResource) {
        String fileNameNoExtension = this.getFileNameNoExtension(urlResource);
        Pattern pattern = Pattern.compile("(.*)-(\\d)(.*?)");
        Matcher m = pattern.matcher(fileNameNoExtension);
        Assert.isTrue((boolean)m.matches(), (String)("Could not parse version from " + this.getUri(urlResource) + ", expected format is <artifactId>-<version>.jar"));
        return m;
    }

    private String getFileNameNoExtension(UrlResource urlResource) {
        URI uri = this.getUri(urlResource);
        String uriPath = uri.getPath();
        Assert.isTrue((boolean)StringUtils.hasText((String)uriPath), (String)"URI path doesn't exist");
        String lastSegment = new File(uriPath).getName();
        Assert.isTrue((lastSegment.indexOf(".") != -1 ? 1 : 0) != 0, (String)"URI file name extension doesn't exist");
        return lastSegment.substring(0, lastSegment.lastIndexOf("."));
    }

    private URI getUri(UrlResource urlResource) {
        URI uri;
        try {
            uri = urlResource.getURI();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not get URI from " + urlResource.getDescription());
        }
        return uri;
    }

    public Resource getResource(String resourceUri) {
        Assert.isTrue((boolean)StringUtils.hasText((String)resourceUri), (String)"Resource URI must not be empty");
        try {
            String scheme = new URI(resourceUri).getScheme();
            if (scheme == null) {
                throw new IllegalArgumentException("Invalid URI schema for resource: " + resourceUri + " Expected URI schema prefix like file://, http:// or classpath:// but got none");
            }
            scheme = scheme.toLowerCase();
            Assert.notNull((Object)scheme, (String)"a scheme (prefix) is required");
            switch (scheme) {
                case "maven": {
                    String coordinates = resourceUri.replaceFirst("maven:\\/*", "");
                    return MavenResource.parse((String)coordinates, (MavenProperties)this.mavenProperties);
                }
                case "docker": {
                    String dockerUri = resourceUri.replaceFirst("docker:\\/*", "");
                    return new DockerResource(dockerUri);
                }
                case "http": 
                case "https": {
                    return new DownloadingUrlResourceLoader().getResource(resourceUri);
                }
            }
            return new DefaultResourceLoader().getResource(resourceUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getResourceWithoutVersion(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource must not be null");
        if (resource instanceof MavenResource) {
            MavenResource mavenResource = (MavenResource)resource;
            StringBuilder mavenResourceStringBuilder = new StringBuilder();
            mavenResourceStringBuilder.append(String.format("maven://%s:%s", mavenResource.getGroupId(), mavenResource.getArtifactId()));
            if (StringUtils.hasText((String)mavenResource.getExtension())) {
                mavenResourceStringBuilder.append(":" + mavenResource.getExtension());
            } else {
                mavenResourceStringBuilder.append(":jar");
            }
            if (StringUtils.hasText((String)mavenResource.getClassifier())) {
                mavenResourceStringBuilder.append(":" + mavenResource.getClassifier());
            }
            return mavenResourceStringBuilder.toString();
        }
        if (resource instanceof DockerResource) {
            DockerResource dockerResource = (DockerResource)resource;
            return this.getDockerImageWithoutVersion(dockerResource);
        }
        if (resource instanceof UrlResource) {
            return this.getUrlResourceWithoutVersion((UrlResource)resource);
        }
        throw new IllegalArgumentException("Do not support extracting resource from Resource of type " + resource.getClass().getSimpleName());
    }

    String getUrlResourceWithoutVersion(UrlResource urlResource) {
        String version = this.getUrlResourceVersion(urlResource);
        URI uri = this.getUri(urlResource);
        String theRest = uri.toString().substring(0, uri.toString().indexOf("-" + version));
        return theRest;
    }

    private String getDockerImageWithoutVersion(DockerResource dockerResource) {
        try {
            String uri = dockerResource.getURI().toString().substring("docker:".length());
            DockerImage dockerImage = DockerImage.fromImageName(uri);
            StringBuilder sb = new StringBuilder("docker:");
            if (StringUtils.hasText((String)dockerImage.getHost())) {
                sb.append(dockerImage.getHost());
                sb.append("/");
            }
            sb.append(dockerImage.getNamespaceAndRepo());
            return sb.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Docker Resource URI is not in expected format to extract version. " + dockerResource.getDescription(), e);
        }
    }

    public Resource getMetadataResource(URI appUri, URI metadataUri) {
        if (metadataUri != null) {
            return this.metadataResourceLoader.getResource(metadataUri.toString());
        }
        Resource appResource = this.getResource(appUri.toString());
        return appResource instanceof DockerResource ? null : appResource;
    }
}

