/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata.container.authorization;

import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImage;
import org.springframework.cloud.dataflow.configuration.metadata.container.RegistryConfiguration;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.RegistryAuthorizer;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;

public class BasicAuthRegistryAuthorizer
implements RegistryAuthorizer {
    @Override
    public RegistryConfiguration.AuthorizationType getType() {
        return RegistryConfiguration.AuthorizationType.basicauth;
    }

    @Override
    public HttpHeaders getAuthorizationHeaders(ContainerImage containerImage, RegistryConfiguration registryConfiguration) {
        Assert.isTrue((registryConfiguration.getAuthorizationType() == this.getType() ? 1 : 0) != 0, (String)("Incorrect type: " + (Object)((Object)registryConfiguration.getAuthorizationType())));
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(registryConfiguration.getUser(), registryConfiguration.getSecret());
        return headers;
    }
}

