/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata.container.authorization;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.AmazonECRClientBuilder;
import com.amazonaws.services.ecr.model.AuthorizationData;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImage;
import org.springframework.cloud.dataflow.configuration.metadata.container.RegistryConfiguration;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.RegistryAuthorizer;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AwsEcrAuthorizer
implements RegistryAuthorizer {
    public static final String AWS_REGION = "region";
    public static final String REGISTRY_IDS = "registryIds";

    @Override
    public RegistryConfiguration.AuthorizationType getType() {
        return RegistryConfiguration.AuthorizationType.awsecr;
    }

    @Override
    public HttpHeaders getAuthorizationHeaders(ContainerImage containerImage, RegistryConfiguration registryConfiguration) {
        Assert.isTrue((registryConfiguration.getAuthorizationType() == this.getType() ? 1 : 0) != 0, (String)("Incorrect type: " + (Object)((Object)registryConfiguration.getAuthorizationType())));
        AmazonECRClientBuilder ecrBuilder = AmazonECRClientBuilder.standard();
        if (registryConfiguration.getExtra().containsKey(AWS_REGION)) {
            ecrBuilder.withRegion(registryConfiguration.getExtra().get(AWS_REGION));
        }
        if (StringUtils.hasText((String)registryConfiguration.getUser()) && StringUtils.hasText((String)registryConfiguration.getSecret())) {
            ecrBuilder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(registryConfiguration.getUser(), registryConfiguration.getSecret())));
        }
        AmazonECR client = (AmazonECR)ecrBuilder.build();
        GetAuthorizationTokenRequest request = new GetAuthorizationTokenRequest();
        if (registryConfiguration.getExtra().containsKey(REGISTRY_IDS)) {
            request.withRegistryIds(registryConfiguration.getExtra().get(REGISTRY_IDS).split(","));
        }
        GetAuthorizationTokenResult response = client.getAuthorizationToken(request);
        String token = ((AuthorizationData)response.getAuthorizationData().iterator().next()).getAuthorizationToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(token);
        return headers;
    }
}

