/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.springframework.boot.loader.ExecutableArchiveLauncher;
import org.springframework.boot.loader.LaunchedURLClassLoader;
import org.springframework.boot.loader.archive.Archive;

public class BootClassLoaderFactory {
    private static final String BOOT_13_LIBS_LOCATION = "lib/";
    private static final String BOOT_14_LIBS_LOCATION = "BOOT-INF/lib/";
    private static final String BOOT_14_CLASSESS_LOCATION = "BOOT-INF/classes/";
    private final Archive archive;
    private final ClassLoader parent;

    public BootClassLoaderFactory(Archive archive, ClassLoader parent) {
        this.archive = archive;
        this.parent = parent;
    }

    public URLClassLoader createClassLoader() {
        boolean useBoot14Layout = false;
        for (Archive.Entry entry : this.archive) {
            if (!entry.getName().startsWith(BOOT_14_LIBS_LOCATION)) continue;
            useBoot14Layout = true;
            break;
        }
        ClassLoaderExposingLauncher launcher = useBoot14Layout ? new Boot14ClassLoaderExposingLauncher() : new Boot13ClassLoaderExposingLauncher();
        return launcher.createClassLoader();
    }

    private class Boot14ClassLoaderExposingLauncher
    extends ClassLoaderExposingLauncher {
        private Boot14ClassLoaderExposingLauncher() {
        }

        protected boolean isNestedArchive(Archive.Entry entry) {
            return !entry.isDirectory() && entry.getName().startsWith(BootClassLoaderFactory.BOOT_14_LIBS_LOCATION) || entry.isDirectory() && entry.getName().equals(BootClassLoaderFactory.BOOT_14_CLASSESS_LOCATION);
        }

        protected void postProcessClassPathArchives(List<Archive> archives) throws Exception {
            archives.add(0, this.getArchive());
        }
    }

    private class Boot13ClassLoaderExposingLauncher
    extends ClassLoaderExposingLauncher {
        private Boot13ClassLoaderExposingLauncher() {
        }

        protected boolean isNestedArchive(Archive.Entry entry) {
            return !entry.isDirectory() && entry.getName().startsWith(BootClassLoaderFactory.BOOT_13_LIBS_LOCATION);
        }

        protected void postProcessClassPathArchives(List<Archive> archives) throws Exception {
            archives.add(0, this.getArchive());
        }
    }

    private abstract class ClassLoaderExposingLauncher
    extends ExecutableArchiveLauncher {
        ClassLoaderExposingLauncher() {
            super(BootClassLoaderFactory.this.archive);
        }

        protected ClassLoader createClassLoader(URL[] urls) throws Exception {
            return new LaunchedURLClassLoader(urls, BootClassLoaderFactory.this.parent);
        }

        public URLClassLoader createClassLoader() {
            try {
                return (URLClassLoader)this.createClassLoader(this.getClassPathArchives());
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while creating ClassLoader for " + BootClassLoaderFactory.this.archive);
            }
        }
    }
}

