/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.BootApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageMetadataProperties;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageParser;
import org.springframework.cloud.dataflow.configuration.metadata.container.DefaultContainerImageMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.container.RegistryConfiguration;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.AwsEcrAuthorizer;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.BasicAuthRegistryAuthorizer;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.DockerConfigJsonSecretToRegistryConfigurationConverter;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.DockerOAuth2RegistryAuthorizer;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.RegistryAuthorizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={ContainerImageMetadataProperties.class})
public class ApplicationConfigurationMetadataResolverAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationConfigurationMetadataResolverAutoConfiguration.class);

    @Bean
    public RegistryAuthorizer dockerOAuth2RegistryAuthorizer(@Qualifier(value="containerRestTemplate") RestTemplate containerRestTemplate, @Qualifier(value="noSslVerificationContainerRestTemplate") RestTemplate noSslVerificationContainerRestTemplate) {
        return new DockerOAuth2RegistryAuthorizer(containerRestTemplate, noSslVerificationContainerRestTemplate);
    }

    @Bean
    public RegistryAuthorizer basicAuthRegistryAuthorizer() {
        return new BasicAuthRegistryAuthorizer();
    }

    @Bean
    public RegistryAuthorizer awsRegistryAuthorizer() {
        return new AwsEcrAuthorizer();
    }

    @Bean
    public ContainerImageParser containerImageParser(ContainerImageMetadataProperties properties) {
        return new ContainerImageParser(properties.getDefaultRegistryHost(), properties.getDefaultRepositoryTag(), properties.getOfficialRepositoryNamespace());
    }

    @Bean
    @ConditionalOnMissingBean(value={ContainerImageMetadataResolver.class})
    public DefaultContainerImageMetadataResolver containerImageMetadataResolver(@Qualifier(value="containerRestTemplate") RestTemplate containerRestTemplate, @Qualifier(value="noSslVerificationContainerRestTemplate") RestTemplate trustAnySslRestTemplate, ContainerImageParser imageNameParser, Map<String, RegistryConfiguration> registryConfigurationMap, List<RegistryAuthorizer> registryAuthorizers) {
        return new DefaultContainerImageMetadataResolver(containerRestTemplate, trustAnySslRestTemplate, imageNameParser, registryConfigurationMap, registryAuthorizers);
    }

    @Bean
    @ConditionalOnMissingBean(value={ApplicationConfigurationMetadataResolver.class})
    public ApplicationConfigurationMetadataResolver metadataResolver(DefaultContainerImageMetadataResolver containerImageMetadataResolver) {
        return new BootApplicationConfigurationMetadataResolver(containerImageMetadataResolver);
    }

    @Bean
    public Map<String, RegistryConfiguration> registryConfigurationMap(ContainerImageMetadataProperties properties, @Value(value="${.dockerconfigjson:#{null}}") String dockerConfigJsonSecret, DockerConfigJsonSecretToRegistryConfigurationConverter secretToRegistryConfigurationConverter) {
        Map<String, RegistryConfiguration> registryConfigurationMap = properties.getRegistryConfigurations().entrySet().stream().collect(Collectors.toMap(e -> ((RegistryConfiguration)e.getValue()).getRegistryHost(), Map.Entry::getValue));
        registryConfigurationMap.values().stream().filter(rc -> rc.getAuthorizationType() == RegistryConfiguration.AuthorizationType.dockeroauth2).filter(rc -> !rc.getExtra().containsKey("registryAuthUri")).forEach(rc -> {
            String tokenServiceUri = secretToRegistryConfigurationConverter.getDockerTokenServiceUri(rc.getRegistryHost(), rc.getUser(), rc.getSecret());
            if (StringUtils.hasText((String)tokenServiceUri)) {
                rc.getExtra().put("registryAuthUri", tokenServiceUri);
            }
        });
        if (!StringUtils.isEmpty((Object)dockerConfigJsonSecret)) {
            Map<String, RegistryConfiguration> secretsRegistryConfigurationMap = secretToRegistryConfigurationConverter.convert(dockerConfigJsonSecret);
            Map<String, RegistryConfiguration> mergedConfigurations = Stream.concat(secretsRegistryConfigurationMap.entrySet().stream(), registryConfigurationMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (secretConf, propConf) -> {
                RegistryConfiguration rc = new RegistryConfiguration();
                rc.setRegistryHost(secretConf.getRegistryHost());
                rc.setUser(StringUtils.hasText((String)propConf.getUser()) ? propConf.getUser() : secretConf.getUser());
                rc.setSecret(StringUtils.hasText((String)propConf.getSecret()) ? propConf.getSecret() : secretConf.getSecret());
                rc.setAuthorizationType(propConf.getAuthorizationType() != null ? propConf.getAuthorizationType() : secretConf.getAuthorizationType());
                rc.setManifestMediaType(StringUtils.hasText((String)propConf.getManifestMediaType()) ? propConf.getManifestMediaType() : secretConf.getManifestMediaType());
                rc.setDisableSslVerification(propConf.isDisableSslVerification());
                rc.getExtra().putAll(secretConf.getExtra());
                rc.getExtra().putAll(propConf.getExtra());
                return rc;
            }));
            registryConfigurationMap = mergedConfigurations;
        }
        logger.info("Final Registry Configurations: " + registryConfigurationMap);
        return registryConfigurationMap;
    }

    @Bean
    public DockerConfigJsonSecretToRegistryConfigurationConverter secretToRegistryConfigurationConverter(@Qualifier(value="noSslVerificationContainerRestTemplate") RestTemplate trustAnySslRestTemplate) {
        return new DockerConfigJsonSecretToRegistryConfigurationConverter(trustAnySslRestTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"containerRestTemplate"})
    public RestTemplate containerRestTemplate(RestTemplateBuilder builder) {
        return this.initRestTemplateBuilder(builder).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"noSslVerificationContainerRestTemplate"})
    public RestTemplate noSslVerificationContainerRestTemplate(RestTemplateBuilder builder) throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        HttpComponentsClientHttpRequestFactory customRequestFactory = new HttpComponentsClientHttpRequestFactory();
        customRequestFactory.setHttpClient((HttpClient)httpClient);
        return this.initRestTemplateBuilder(builder).requestFactory(() -> customRequestFactory).build();
    }

    private RestTemplateBuilder initRestTemplateBuilder(RestTemplateBuilder builder) {
        StringHttpMessageConverter octetToStringMessageConverter = new StringHttpMessageConverter();
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>(octetToStringMessageConverter.getSupportedMediaTypes());
        mediaTypeList.add(MediaType.APPLICATION_OCTET_STREAM);
        octetToStringMessageConverter.setSupportedMediaTypes(mediaTypeList);
        return builder.additionalMessageConverters(new HttpMessageConverter[]{octetToStringMessageConverter});
    }
}

