/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class UnfinishedConfigurationPropertyNameTaskRecoveryStrategy
extends StacktraceFingerprintingTaskRecoveryStrategy<CheckPointedParseException> {
    private final ProposalsCollectorSupportUtils collectorSupport;

    UnfinishedConfigurationPropertyNameTaskRecoveryStrategy(AppRegistryService appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "file --foo", "file --foo.");
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        TaskDefinition taskDefinition = new TaskDefinition("__dummy", safe);
        AppRegistration appRegistration = this.collectorSupport.findAppRegistration(taskDefinition.getRegisteredAppName(), ApplicationType.task);
        if (appRegistration != null) {
            String startsWith = ProposalsCollectorSupportUtils.computeStartsWith(exception);
            HashSet<String> alreadyPresentOptions = new HashSet<String>(taskDefinition.getProperties().keySet());
            this.collectorSupport.addPropertiesProposals(safe, startsWith, appRegistration, alreadyPresentOptions, collector, detailLevel);
        }
    }
}

