/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class UnfinishedAppNameExpansionStrategy
implements ExpansionStrategy {
    private final AppRegistryService appRegistry;

    UnfinishedAppNameExpansionStrategy(AppRegistryService appRegistry) {
        this.appRegistry = appRegistry;
    }

    @Override
    public boolean addProposals(String text, StreamDefinition streamDefinition, int detailLevel, List<CompletionProposal> collector) {
        StreamAppDefinition lastApp = (StreamAppDefinition)streamDefinition.getDeploymentOrderIterator().next();
        HashSet parameterNames = new HashSet(lastApp.getProperties().keySet());
        parameterNames.removeAll(CompletionUtils.IMPLICIT_PARAMETER_NAMES);
        if (!parameterNames.isEmpty() || !text.endsWith(lastApp.getName())) {
            return false;
        }
        String alreadyTyped = lastApp.getName();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
        List<ApplicationType> validTypesAtThisPosition = Arrays.asList(CompletionUtils.determinePotentialTypes(lastApp, streamDefinition.getAppDefinitions().size() > 1));
        for (AppRegistration appRegistration : this.appRegistry.findAll()) {
            String candidateName = appRegistration.getName();
            if (!validTypesAtThisPosition.contains(appRegistration.getType()) || alreadyTyped.equals(candidateName) || !candidateName.startsWith(alreadyTyped)) continue;
            String expansion = CompletionUtils.maybeQualifyWithLabel(appRegistration.getName(), streamDefinition);
            collector.add(proposals.withSuffix(expansion.substring(alreadyTyped.length())));
        }
        return false;
    }
}

