/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;
import org.springframework.core.io.Resource;

class ProposalsCollectorSupportUtils {
    private final AppRegistryService appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;

    ProposalsCollectorSupportUtils(AppRegistryService appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    void addPropertiesProposals(String text, String startsWith, AppRegistration appRegistration, Set<String> alreadyPresentOptions, List<CompletionProposal> collector, int detailLevel) {
        Resource metadataResource = this.appRegistry.getAppMetadataResource(appRegistration);
        if (metadataResource != null) {
            CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
            for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(metadataResource)) {
                String name = property.getName();
                if (alreadyPresentOptions.contains(name) || !name.startsWith(startsWith)) continue;
                collector.add(proposals.withSeparateTokens("--" + property.getName() + "=", property.getShortDescription()));
            }
            if (detailLevel > 1) {
                for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(metadataResource, true)) {
                    String id = property.getId();
                    if (alreadyPresentOptions.contains(id) || !id.startsWith(startsWith)) continue;
                    collector.add(proposals.withSeparateTokens("--" + property.getId() + "=", property.getShortDescription()));
                }
            }
        }
    }

    void addValueHintsProposals(String dsl, AppRegistration appRegistration, List<CompletionProposal> collector, String propertyName, ValueHintProvider[] valueHintProviders) {
        Resource metadataResource = this.appRegistry.getAppMetadataResource(appRegistration);
        if (metadataResource != null) {
            URLClassLoader classLoader = this.metadataResolver.createAppClassLoader(metadataResource);
            this.doWithClassLoader(classLoader, () -> {
                CompletionProposal.Factory proposals = CompletionProposal.expanding(dsl);
                List whiteList = this.metadataResolver.listProperties(metadataResource);
                for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(metadataResource, true)) {
                    if (!CompletionUtils.isMatchingProperty(propertyName, property, whiteList)) continue;
                    for (ValueHintProvider valueHintProvider : valueHintProviders) {
                        for (ValueHint valueHint : valueHintProvider.generateValueHints(property, classLoader)) {
                            collector.add(proposals.withSuffix(String.valueOf(valueHint.getValue()), valueHint.getShortDescription()));
                        }
                    }
                }
                return null;
            });
        }
    }

    boolean addAlreadyTypedValueHintsProposals(String text, AppRegistration appRegistration, List<CompletionProposal> collector, String propertyName, ValueHintProvider[] valueHintProviders, String alreadyTyped) {
        Resource metadataResource = this.appRegistry.getAppMetadataResource(appRegistration);
        if (metadataResource == null) {
            return false;
        }
        URLClassLoader classLoader = this.metadataResolver.createAppClassLoader(metadataResource);
        return this.doWithClassLoader(classLoader, () -> {
            CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
            List allProps = this.metadataResolver.listProperties(metadataResource, true);
            List whiteListedProps = this.metadataResolver.listProperties(metadataResource);
            for (ConfigurationMetadataProperty property : allProps) {
                if (!CompletionUtils.isMatchingProperty(propertyName, property, whiteListedProps)) continue;
                for (ValueHintProvider valueHintProvider : valueHintProviders) {
                    List<ValueHint> valueHints = valueHintProvider.generateValueHints(property, classLoader);
                    if (!valueHints.isEmpty() && valueHintProvider.isExclusive(property)) {
                        collector.clear();
                    }
                    for (ValueHint valueHint : valueHints) {
                        String candidate = String.valueOf(valueHint.getValue());
                        if (candidate.equals(alreadyTyped) || !candidate.startsWith(alreadyTyped)) continue;
                        collector.add(proposals.withSuffix(candidate.substring(alreadyTyped.length()), valueHint.getShortDescription()));
                    }
                    if (valueHints.isEmpty() || !valueHintProvider.isExclusive(property)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    AppRegistration findAppRegistration(String appName, ApplicationType ... appTypes) {
        AppRegistration lastAppRegistration = null;
        for (ApplicationType appType : appTypes) {
            lastAppRegistration = this.appRegistry.find(appName, appType);
            if (lastAppRegistration == null) continue;
            return lastAppRegistration;
        }
        return null;
    }

    static String computeStartsWith(CheckPointedParseException exception) {
        List tokens = exception.getTokens();
        int tokenPointer = tokens.size() - 1;
        while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
            --tokenPointer;
        }
        StringBuilder startsWithBuffer = null;
        startsWithBuffer = new StringBuilder();
        while (tokenPointer < tokens.size()) {
            Token t = (Token)tokens.get(tokenPointer);
            if (t.isIdentifier()) {
                startsWithBuffer.append(t.stringValue());
            } else {
                startsWithBuffer.append(t.getKind().getTokenChars());
            }
            ++tokenPointer;
        }
        String startsWith = startsWithBuffer.toString();
        return startsWith;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithClassLoader(URLClassLoader classLoader, Callback<T> callback) {
        T t = callback.invoke();
        return t;
        finally {
            try {
                classLoader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static interface Callback<T> {
        public T invoke();
    }
}

