/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.TaskExpansionStrategy;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class ConfigurationPropertyValueHintTaskExpansionStrategy
implements TaskExpansionStrategy {
    private final ProposalsCollectorSupportUtils collectorSupport;
    @Autowired
    private ValueHintProvider[] valueHintProviders = new ValueHintProvider[0];

    ConfigurationPropertyValueHintTaskExpansionStrategy(AppRegistryService appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public boolean addProposals(String text, TaskDefinition parseResult, int detailLevel, List<CompletionProposal> collector) {
        HashSet propertyNames = new HashSet(parseResult.getProperties().keySet());
        propertyNames.removeAll(CompletionUtils.IMPLICIT_TASK_PARAMETER_NAMES);
        if (text.endsWith(" ") || propertyNames.isEmpty()) {
            return false;
        }
        String propertyName = this.recoverPropertyName(text);
        String alreadyTyped = (String)parseResult.getProperties().get(propertyName);
        AppRegistration lastAppRegistration = this.collectorSupport.findAppRegistration(parseResult.getRegisteredAppName(), ApplicationType.task);
        if (lastAppRegistration != null) {
            return this.collectorSupport.addAlreadyTypedValueHintsProposals(text, lastAppRegistration, collector, propertyName, this.valueHintProviders, alreadyTyped);
        }
        return false;
    }

    private String recoverPropertyName(String text) {
        try {
            new TaskDefinition("__dummy", text + " --");
        }
        catch (CheckPointedParseException exception) {
            int end;
            List tokens = exception.getTokens();
            int tokenPointer = end = tokens.size() - 1 - 2;
            while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
                --tokenPointer;
            }
            StringBuilder builder = new StringBuilder();
            while (tokenPointer < end) {
                Token t = (Token)tokens.get(tokenPointer);
                if (t.isIdentifier()) {
                    builder.append(t.stringValue());
                } else {
                    builder.append(t.getKind().getTokenChars());
                }
                ++tokenPointer;
            }
            return builder.toString();
        }
        throw new AssertionError((Object)"Can't be reached");
    }
}

