/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.restdocs.test.autoconfigure.RestDocsWebTestClientConfigurationCustomizer;
import org.springframework.cloud.contract.wiremock.restdocs.DynamicPortPlaceholderInserterPreprocessor;
import org.springframework.cloud.contract.wiremock.restdocs.WireMockSnippet;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentationConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebTestClientRestDocumentationConfigurer.class})
public class WireMockWebTestClientConfiguration
implements RestDocsWebTestClientConfigurationCustomizer {
    private final Environment environment;

    public WireMockWebTestClientConfiguration(Environment environment) {
        this.environment = environment;
    }

    public void customize(WebTestClientRestDocumentationConfigurer configurer) {
        if (this.environment.getProperty("wiremock.placeholders.enabled", "true").equals("true")) {
            configurer.operationPreprocessors().withResponseDefaults(new OperationPreprocessor[]{new DynamicPortPlaceholderInserterPreprocessor()});
        }
        configurer.snippets().withAdditionalDefaults(new Snippet[]{new WireMockSnippet()});
    }
}

