/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Request;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.cloud.contract.wiremock.restdocs.WireMockHttpRequestAdapter;
import org.springframework.cloud.contract.wiremock.restdocs.WireMockVerifyHelper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentationConfigurer;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.util.ReflectionUtils;

public class ContractExchangeHandler
extends WireMockVerifyHelper<EntityExchangeResult<?>, ContractExchangeHandler>
implements Consumer<EntityExchangeResult<byte[]>> {
    @Override
    public void accept(EntityExchangeResult<byte[]> result) {
        this.configure(result);
    }

    @Override
    protected ResponseDefinitionBuilder getResponseDefinition(EntityExchangeResult<?> result) {
        ResponseDefinitionBuilder definition = ResponseDefinitionBuilder.responseDefinition().withBody(result.getResponseBodyContent()).withStatus(result.getStatus().value());
        this.addResponseHeaders(definition, result.getResponseHeaders());
        return definition;
    }

    private void addResponseHeaders(ResponseDefinitionBuilder definition, HttpHeaders httpHeaders) {
        for (String name : httpHeaders.headerNames()) {
            definition.withHeader(name, httpHeaders.get(name).toArray(new String[0]));
        }
    }

    @Override
    protected Map<String, Object> getConfiguration(EntityExchangeResult<?> result) {
        Field field = ReflectionUtils.findField(WebTestClientRestDocumentationConfigurer.class, (String)"configurations");
        ReflectionUtils.makeAccessible((Field)field);
        String index = result.getRequestHeaders().getFirst("WebTestClient-Request-Id");
        Map map = (Map)((Map)ReflectionUtils.getField((Field)field, null)).get(index);
        if (map == null) {
            return new HashMap<String, Object>();
        }
        return map;
    }

    @Override
    protected Request getWireMockRequest(EntityExchangeResult<?> result) {
        return new WireMockHttpRequestAdapter(result);
    }

    @Override
    protected MediaType getContentType(EntityExchangeResult<?> result) {
        return result.getRequestHeaders().getContentType();
    }

    @Override
    protected byte[] getRequestBodyContent(EntityExchangeResult<?> result) {
        return result.getRequestBodyContent();
    }
}

