/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.contract.wiremock.WireMockConfigurationCustomizer;
import org.springframework.cloud.contract.wiremock.WireMockProperties;
import org.springframework.cloud.contract.wiremock.WireMockSpring;
import org.springframework.cloud.contract.wiremock.WireMockStubMapping;
import org.springframework.cloud.contract.wiremock.file.ResourcesFileSource;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={WireMockProperties.class})
public class WireMockConfiguration
implements SmartLifecycle {
    static final String WIREMOCK_SERVER_BEAN_NAME = "wireMockServer";
    private static final Log log = LogFactory.getLog(WireMockConfiguration.class);
    @Autowired
    WireMockProperties wireMock;
    private volatile boolean running;
    private WireMockServer server;
    @Autowired(required=false)
    private Options options;
    @Autowired(required=false)
    private WireMockConfigurationCustomizer customizer;
    @Autowired
    private DefaultListableBeanFactory beanFactory;
    @Autowired
    private ResourceLoader resourceLoader;

    @PostConstruct
    public void init() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Running initialization of the WireMock configuration");
        }
        if (this.options == null) {
            com.github.tomakehurst.wiremock.core.WireMockConfiguration factory = WireMockSpring.options();
            if (this.wireMock.getServer().getPort() != 8080) {
                factory.port(this.wireMock.getServer().getPort());
            }
            if (this.wireMock.getServer().getHttpsPort() != -1) {
                factory.httpsPort(Integer.valueOf(this.wireMock.getServer().getHttpsPort()));
            }
            this.registerFiles(factory);
            factory.notifier((Notifier)new Slf4jNotifier(true));
            if (this.wireMock.getPlaceholders().isEnabled()) {
                factory.extensions(new Extension[]{new ResponseTemplateTransformer(false)});
            }
            this.options = factory;
            if (this.customizer != null) {
                this.customizer.customize(factory);
            }
        }
        this.reRegisterServerWithResetMappings();
        this.reRegisterBeans();
        this.updateCurrentServer();
    }

    private void reRegisterBeans() {
        if (!this.beanFactory.containsBean(WIREMOCK_SERVER_BEAN_NAME)) {
            this.beanFactory.registerSingleton(WIREMOCK_SERVER_BEAN_NAME, (Object)this.server);
        } else {
            this.beanFactory.destroySingleton(WIREMOCK_SERVER_BEAN_NAME);
            this.beanFactory.registerSingleton(WIREMOCK_SERVER_BEAN_NAME, (Object)this.server);
        }
    }

    private void reRegisterServer() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a new server at http port [" + this.wireMock.getServer().getPort() + "] and https port [" + this.wireMock.getServer().getHttpsPort() + "]"));
        }
        if (this.isRunning()) {
            this.server.stop();
        }
        this.server = new WireMockServer(this.options);
        this.server.start();
        this.updateCurrentServer();
        this.logRegisteredMappings();
    }

    private void logRegisteredMappings() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("WireMock server has [" + this.server.getStubMappings().size() + "] stubs registered"));
        }
    }

    void reRegisterServerWithResetMappings() {
        this.reRegisterServer();
        if (this.server.isRunning()) {
            this.resetMappings();
            this.updateCurrentServer();
        }
    }

    void resetMappings() {
        if (this.server.isRunning()) {
            this.server.resetAll();
            WireMock.reset();
            this.registerStubs();
            this.logRegisteredMappings();
        }
    }

    private void registerStubs() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will register [" + this.wireMock.getServer().getStubs().length + "] stubs"));
        }
        for (String stubs : this.wireMock.getServer().getStubs()) {
            if (!StringUtils.hasText((String)stubs)) continue;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            StringBuilder pattern = new StringBuilder(stubs);
            if (!stubs.contains("*")) {
                if (!stubs.endsWith("/")) {
                    pattern.append("/");
                }
                pattern.append("**/*.json");
            }
            try {
                for (Resource resource : resolver.getResources(pattern.toString())) {
                    try (InputStream inputStream = resource.getInputStream();){
                        StubMapping stubMapping = WireMockStubMapping.buildFrom(StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                        this.server.addStubMapping(stubMapping);
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void registerFiles(com.github.tomakehurst.wiremock.core.WireMockConfiguration factory) throws IOException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String files : this.wireMock.getServer().getFiles()) {
            if (!StringUtils.hasText((String)files)) continue;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            for (Resource resource : resolver.getResources(files)) {
                if (!resource.exists()) continue;
                resources.add(resource);
            }
        }
        if (!resources.isEmpty()) {
            ResourcesFileSource fileSource = new ResourcesFileSource(resources.toArray(new Resource[0]));
            factory.fileSource((FileSource)fileSource);
        }
    }

    public void start() {
        if (this.isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Server is already running");
            }
            return;
        }
        this.server.start();
        this.updateCurrentServer();
    }

    private void updateCurrentServer() {
        WireMock.configureFor((WireMock)new WireMock((Admin)this.server));
        this.running = true;
        if (log.isDebugEnabled() && this.server.isRunning()) {
            log.debug((Object)("Started WireMock at port [" + this.server.port() + "]. It has [" + this.server.getStubMappings().size() + "] mappings registered"));
        }
    }

    public void stop() {
        if (this.running) {
            this.server.stop();
            this.server = null;
            this.running = false;
            this.options = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopped WireMock instance");
            }
            this.beanFactory.destroySingleton(WIREMOCK_SERVER_BEAN_NAME);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Server already stopped");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

