/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.SocketUtils;

@Order(value=0x7FFFFFFF)
public class WireMockApplicationListener
implements ApplicationListener<ApplicationPreparedEvent> {
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.registerPort(event.getApplicationContext().getEnvironment());
    }

    private void registerPort(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources;
        int httpsPortProperty;
        Integer httpPortProperty = (Integer)environment.getProperty("wiremock.server.port", Integer.class);
        if (httpPortProperty == null) {
            return;
        }
        if (httpPortProperty.equals(0)) {
            MutablePropertySources propertySources2 = environment.getPropertySources();
            this.addPropertySource(propertySources2);
            Map source = (Map)((MapPropertySource)propertySources2.get("wiremock")).getSource();
            source.put("wiremock.server.port", SocketUtils.findAvailableTcpPort((int)10000, (int)12500));
            source.put("wiremock.server.port-dynamic", true);
        }
        if ((httpsPortProperty = ((Integer)environment.getProperty("wiremock.server.https-port", Integer.class, (Object)0)).intValue()) == 0) {
            propertySources = environment.getPropertySources();
            this.addPropertySource(propertySources);
            Map source = (Map)((MapPropertySource)propertySources.get("wiremock")).getSource();
            source.put("wiremock.server.https-port", SocketUtils.findAvailableTcpPort((int)12500, (int)15000));
            source.put("wiremock.server.https-port-dynamic", true);
        } else if (httpsPortProperty == -1) {
            propertySources = environment.getPropertySources();
            this.addPropertySource(propertySources);
            Map source = (Map)((MapPropertySource)propertySources.get("wiremock")).getSource();
            source.put("wiremock.server.https-port-dynamic", true);
        }
    }

    private void addPropertySource(MutablePropertySources propertySources) {
        if (!propertySources.contains("wiremock")) {
            propertySources.addFirst((PropertySource)new MapPropertySource("wiremock", new HashMap()));
        } else {
            PropertySource wiremock = propertySources.remove("wiremock");
            propertySources.addFirst(wiremock);
        }
    }
}

