/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.core.Options;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
class ContainerProperties {
    private Options options;
    private Integer localPort;
    private Integer localHttpsPort;
    @Autowired
    private ConfigurableApplicationContext context;

    @Autowired
    public ContainerProperties(Options options) {
        this.options = options;
    }

    public int port() {
        if (this.options.httpsSettings().enabled()) {
            return this.options.portNumber();
        }
        if (this.localPort != null) {
            return this.localPort;
        }
        EmbeddedWebApplicationContext embedded = (EmbeddedWebApplicationContext)this.context;
        return embedded.getEmbeddedServletContainer().getPort();
    }

    public int httpsPort() {
        if (this.localHttpsPort != null) {
            return this.localHttpsPort;
        }
        return this.options.httpsSettings().port();
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public void setLocalHttpsPort(int localHttpsPort) {
        this.localHttpsPort = localHttpsPort;
    }
}

